/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.ui.dialog;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.UCD;
import com.huawei.migration.common.util.resource.PropertiesResourceUtil;
import com.huawei.migration.common.util.resource.ToolResourceGetter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class ShowHelpLinkDialog {
    private final String message;
    private final Runnable openHelpFileAction;
    private final JDialog dialog;

    public ShowHelpLinkDialog(Window parent, String message, String helpChapter, Runnable openHelpFileAction) {
        this.message = message + System.lineSeparator() + PropertiesResourceUtil.getInnerMsg("migration.dialog.info.help.chapter.info", helpChapter);
        this.dialog = new JDialog(parent);
        this.openHelpFileAction = openHelpFileAction;
        this.initDialog();
    }

    private void initDialog() {
        this.dialog.add(UCD.buildVBoxTop((Component[])new Component[]{this.createMsgComp(), this.createBtnComp()}));
        this.dialog.setTitle(PropertiesResourceUtil.getInnerMsg("migration.dialog.info.title"));
        this.dialog.setMinimumSize(new Dimension(350, 230));
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setModal(true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setLocationRelativeTo(this.dialog.getParent());
        this.dialog.setVisible(true);
    }

    private JComponent createMsgComp() {
        return UiMethod.buildFrameSpace((JComponent)UCD.buildVBoxTop((Component[])new Component[]{Box.createVerticalStrut(5), UCD.buildHBoxLeft((Component[])new Component[]{this.getIconComp(), this.getMessageComp()})}), (int)12);
    }

    private JComponent getIconComp() {
        return UCD.buildVBoxTop((Component[])new Component[]{Box.createVerticalStrut(5), new JLabel(ToolResourceGetter.getImage("information.png"))});
    }

    private JComponent getMessageComp() {
        return UCD.buildVerticalBox(null, (Component[])new Component[]{this.getMessageArea(), Box.createVerticalGlue(), this.getHelpLinkComp()});
    }

    private IsmTextArea getMessageArea() {
        IsmTextArea messageArea = UCD.createTextArea((String)this.message);
        messageArea.setColumns(25);
        FontMetrics fontMetrics = messageArea.getFontMetrics(messageArea.getFont());
        int row = fontMetrics.stringWidth(this.message) / (messageArea.getColumnWidth() * 25);
        messageArea.setRows(row + this.message.split("\n").length);
        return messageArea;
    }

    private JComponent getHelpLinkComp() {
        ToolHyperLinkLabel linkLabel = new ToolHyperLinkLabel(PropertiesResourceUtil.getInnerMsg("migration.dialog.info.help.link"));
        linkLabel.addClickListener((ToolHyperLinkLabel.ClickListener & Serializable)event -> this.openHelpFileAction.run());
        return UCD.buildHBoxLeft((Component[])new Component[]{linkLabel});
    }

    private JComponent createBtnComp() {
        JButton confirmBtn = UiMethod.createButton((String)PropertiesResourceUtil.getInnerMsg("migration.dialog.btn.confirm"), (char)'O');
        confirmBtn.addActionListener(event -> this.dialog.dispose());
        return UCD.buildVBoxTop((Component[])new Component[]{new JSeparator(), UCD.buildHBoxCentert((Component[])new Component[]{confirmBtn}), Box.createVerticalStrut(2)});
    }
}

