/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.date;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeUtil {
    private static final Logger log = LoggerFactory.getLogger(DateTimeUtil.class);
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");

    public static String getNowTimestamp() {
        return LocalDateTime.now().format(TIMESTAMP_FORMATTER);
    }

    public static String formatDate(Date date) {
        return DateTimeUtil.formatDate(date, DATE_FORMATTER);
    }

    public static String formatDate(Date date, DateTimeFormatter formatter) {
        return DateTimeUtil.getLocalDateTime(date).format(formatter);
    }

    public static LocalDateTime getLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime getLocalDateTime(long millis) {
        return DateTimeUtil.getLocalDateTime(new Date(millis));
    }

    public static LocalDateTime getLocalDateTime(long millis, String zoneId) {
        return new Date(millis).toInstant().atZone(ZoneId.of(zoneId)).toLocalDateTime();
    }

    public static LocalDate parseDate(String dateStr) {
        try {
            return LocalDate.parse(dateStr);
        }
        catch (Exception e) {
            log.error("Parse date to LocalDate error.", (Throwable)e);
            return LocalDate.MIN;
        }
    }

    public static Date getDate(LocalDateTime dateTime) {
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    private DateTimeUtil() {
    }
}

