/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.encrypt;

import com.huawei.baize.base.character.CharacterUtils;
import com.huawei.migration.common.util.thread.ThreadPoolFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureRandomHelper {
    private static final Logger log = LoggerFactory.getLogger(SecureRandomHelper.class);
    private static final char[] UPPER_CASE_LETTER = CharacterUtils.upperAlphaChars();
    private static final char[] LOWER_CASE_LETTER = CharacterUtils.lowerAlphaChars();
    private static final char[] SPECIAL_CHARS = CharacterUtils.specialChars();
    private static final char[] DIGITS = CharacterUtils.numericChars();
    private static final int RANDOM_QUANTITY = 260 * SPECIAL_CHARS.length;
    private static final int RANDOM_QUANTITY_NO_SPECIAL = 780;
    private static final int SEED_LENGTH = 128;
    private static final String SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    private static byte[] seed;

    public static char[] getRandomChars(int length) throws NoSuchAlgorithmException {
        return SecureRandomHelper.getRandomChars(length, false);
    }

    public static char[] getRandomCode(int length) throws NoSuchAlgorithmException {
        return SecureRandomHelper.getRandomChars(length, true);
    }

    private static char[] getRandomChars(int length, boolean withSpecialChars) throws NoSuchAlgorithmException {
        if (length <= 0) {
            throw new IllegalArgumentException("the random length cannot lower than 1.");
        }
        SecureRandom secureRandom = SecureRandomHelper.getSecureRandom();
        char[] randomCode = new char[length];
        int firstCharInt = secureRandom.nextInt(26);
        randomCode[0] = firstCharInt % 2 == 0 ? UPPER_CASE_LETTER[firstCharInt] : LOWER_CASE_LETTER[firstCharInt];
        for (int i = 1; i < length; ++i) {
            randomCode[i] = withSpecialChars ? SecureRandomHelper.getNextChar(secureRandom, RANDOM_QUANTITY, 4) : SecureRandomHelper.getNextChar(secureRandom, 780, 3);
        }
        return randomCode;
    }

    private static char getNextChar(SecureRandom secureRandom, int quantity, int typeCount) {
        int nextInt = secureRandom.nextInt(quantity);
        switch (nextInt % typeCount) {
            case 0: {
                return UPPER_CASE_LETTER[nextInt % 26];
            }
            case 1: {
                return LOWER_CASE_LETTER[nextInt % 26];
            }
            case 2: {
                return DIGITS[nextInt % 10];
            }
        }
        return SPECIAL_CHARS[nextInt % SPECIAL_CHARS.length];
    }

    public static SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        if (SystemUtils.IS_OS_LINUX) {
            SecureRandomHelper.initSeed();
            return SecureRandomHelper.getLinuxSecureRandom();
        }
        return SecureRandom.getInstanceStrong();
    }

    private static void initSeed() {
        if (seed != null) {
            return;
        }
        try {
            ExecutorService executorService = ThreadPoolFactory.newFixedThreadPool(1, "init-secure-random-seed");
            CompletableFuture.supplyAsync(() -> {
                seed = SecureRandom.getSeed(128);
                return seed;
            }, executorService).get(30L, TimeUnit.SECONDS);
            executorService.shutdownNow();
        }
        catch (Exception e) {
            log.warn("failed to init seed: {}", (Object)e.getMessage());
        }
    }

    private static SecureRandom getLinuxSecureRandom() throws NoSuchAlgorithmException {
        if (seed != null) {
            return new SecureRandom(seed);
        }
        return SecureRandom.getInstance(SECURE_RANDOM_ALGORITHM);
    }

    private SecureRandomHelper() {
    }
}

