/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.encrypt;

import com.huawei.encryptbase.exception.ProcessEncryptException;
import com.huawei.encryptbase.utils.AesEncryptUtils;
import com.huawei.encryptbase.utils.CryptParamPropUtils;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.crypt.CryptoAPI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolEncryptor {
    private static final Logger log = LoggerFactory.getLogger(ToolEncryptor.class);

    public static void resetKmcKeyStoreLocation(Path ksConfigDir) {
        CryptParamPropUtils.editKmcConfig((String)"primary_key_store_file", (String)ToolEncryptor.resolveKeyStoreNewPath(ksConfigDir, CryptParamPropUtils.getPrimaryKeyStoreFile()));
        CryptParamPropUtils.editKmcConfig((String)"standby_key_store_file", (String)ToolEncryptor.resolveKeyStoreNewPath(ksConfigDir, CryptParamPropUtils.getStandbyKeyStoreFile()));
    }

    private static String resolveKeyStoreNewPath(Path ksConfigDir, String oldConfigPath) {
        return ksConfigDir.resolve(Paths.get(oldConfigPath, new String[0]).getFileName()).toString();
    }

    public static String encrypt(char[] tokenChars) {
        if (tokenChars == null || tokenChars.length == 0) {
            return "";
        }
        return ToolEncryptor.encrypt(String.valueOf(tokenChars));
    }

    public static String encrypt(String token) {
        try {
            return StringUtils.isEmpty((CharSequence)token) ? "" : AesEncryptUtils.encryptByAes((String)token);
        }
        catch (ProcessEncryptException e) {
            log.error("Encrypt error.", (Throwable)e);
            return "";
        }
    }

    public static String decrypt(String encryptedToken) {
        try {
            return StringUtils.isEmpty((CharSequence)encryptedToken) ? "" : AesEncryptUtils.decryptByAes((String)encryptedToken);
        }
        catch (ProcessEncryptException e) {
            log.error("Decrypt error.", (Throwable)e);
            return "";
        }
    }

    public static void updateSecretKey() throws AppException {
        CryptoAPI.getInstance().updateRootKey();
    }

    private ToolEncryptor() {
    }
}

