/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.execute;

import com.huawei.migration.common.exception.execute.ExecuteOsCmdRuntimeException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdProcessor
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(CmdProcessor.class);
    private final Object $lock = new Object[0];
    public static final String CMD_EXECUTE_TIMEOUT = "CMD_EXECUTE_TIMEOUT";
    private static final int DEFAULT_TIMEOUT_SECONDS = 60;
    private static final List<String> WINDOWS_DEFAULT_CMD_END_MARKS = Collections.singletonList(">");
    private final Process process;
    private final List<String> cmdEndMarks;
    private final BufferedWriter cmdWriter;
    private final List<String> cmdOutCache = new ArrayList<String>();
    private final List<String> resultLines = new ArrayList<String>();

    public CmdProcessor() throws IOException {
        this(Collections.emptyList());
    }

    public CmdProcessor(List<String> cmdEndMarks) throws IOException {
        this.process = new ProcessBuilder("cmd.exe").redirectErrorStream(true).start();
        this.cmdEndMarks = cmdEndMarks;
        this.cmdWriter = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream(), StandardCharsets.UTF_8));
        new Thread(() -> this.readInput(this.process.getInputStream(), this::consumeCmdOut)).start();
        this.executeCommand("", 60);
    }

    private void readInput(InputStream inputStream, Consumer<String> consumer) {
        try {
            new BufferedReader(new InputStreamReader(inputStream, "gb2312")).lines().forEach(consumer);
        }
        catch (IOException e) {
            log.error("read command output error.", (Throwable)e);
        }
    }

    private void consumeCmdOut(@NotNull String line) {
        this.cmdOutCache.add(line);
        if (this.isCmdEnd(line.trim())) {
            this.moveCmdOutCacheToResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveCmdOutCacheToResult() {
        List<String> list = this.resultLines;
        synchronized (list) {
            this.resultLines.addAll(this.cmdOutCache);
            this.cmdOutCache.clear();
        }
    }

    private boolean isCmdEnd(String line) {
        for (String endMark : WINDOWS_DEFAULT_CMD_END_MARKS) {
            if (!line.endsWith(endMark)) continue;
            return true;
        }
        for (String endMark : this.cmdEndMarks) {
            if (!line.endsWith(endMark)) continue;
            return true;
        }
        return false;
    }

    public String execCmd(String command) {
        return this.execCmd(command, 60);
    }

    public String execCmd(String command, int timeoutSeconds) {
        return this.executeCommand(command, timeoutSeconds);
    }

    private String executeCommand(String command, int timeoutSeconds) {
        Object object = this.$lock;
        synchronized (object) {
            try {
                this.clearResultLinesBeforeExecute();
                this.sendCommand(command);
                return this.waitForResult(timeoutSeconds);
            }
            catch (IOException e) {
                throw new ExecuteOsCmdRuntimeException("send command error.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearResultLinesBeforeExecute() {
        List<String> list = this.resultLines;
        synchronized (list) {
            this.resultLines.clear();
        }
    }

    private void sendCommand(String command) throws IOException {
        this.cmdWriter.write(command);
        this.cmdWriter.newLine();
        this.cmdWriter.newLine();
        this.cmdWriter.flush();
    }

    private String waitForResult(int timeoutSeconds) {
        int timeoutLoopTimes = timeoutSeconds * 10;
        for (int i = 0; i < timeoutLoopTimes; ++i) {
            this.sleepAWhile();
            if (this.resultLines.isEmpty()) continue;
            return this.collectResult();
        }
        return CMD_EXECUTE_TIMEOUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String collectResult() {
        List<String> list = this.resultLines;
        synchronized (list) {
            String result = String.join((CharSequence)System.lineSeparator(), this.resultLines);
            this.resultLines.clear();
            return result;
        }
    }

    private void sleepAWhile() {
        try {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        catch (InterruptedException e) {
            log.error("command waiting period sleep error: {}.", (Object)e.getMessage());
        }
    }

    @Override
    public void close() {
        try {
            this.process.destroyForcibly().waitFor(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("wait for cmd process close error.", (Throwable)e);
        }
    }

    public Process getProcess() {
        return this.process;
    }
}

