/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.execute;

import com.huawei.baize.base.commands.process.ProcessInfo;
import com.huawei.baize.base.commands.process.ProcessResult;
import com.huawei.baize.base.commands.process.ProcessUtils;
import com.huawei.migration.common.exception.execute.ExecuteOsCmdRuntimeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsCommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(OsCommandExecutor.class);
    private static final int DEFAULT_TIMEOUT_MINUTES = 5;

    public static List<String> executeWindowsCmd(String command) {
        return OsCommandExecutor.executeOsCmd("cmd.exe", "/c", command, true);
    }

    public static List<String> executeOsCmd(String type, String param, String command, boolean isPrintLog) {
        return OsCommandExecutor.executeOsCmd(isPrintLog, type, param, command);
    }

    public static List<String> executeOsCmd(boolean isPrintLog, String ... commands) {
        return OsCommandExecutor.executeOsCmd(5L, TimeUnit.MINUTES, isPrintLog, commands);
    }

    public static List<String> executeOsCmd(long timeout, TimeUnit timeUnit, boolean isPrintLog, String ... commands) {
        try {
            ProcessInfo processInfo = ProcessUtils.run((long)timeout, (TimeUnit)timeUnit, (String[])commands);
            List<String> resultLines = OsCommandExecutor.getResultLines((ProcessInfo<ProcessResult, ProcessResult>)processInfo);
            if (isPrintLog) {
                log.info("Execute OS command '{}' with exit value '{}', result: {}{}", new Object[]{String.join((CharSequence)" ", commands), processInfo.exitValue(), System.lineSeparator(), String.join((CharSequence)System.lineSeparator(), resultLines)});
            }
            return resultLines;
        }
        catch (IOException e) {
            throw new ExecuteOsCmdRuntimeException("Execute OS command error.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ExecuteOsCmdRuntimeException("Wait for OS command executing error.", e);
        }
        catch (TimeoutException e) {
            throw new ExecuteOsCmdRuntimeException("Wait for OS command executing timeout.", e);
        }
    }

    private static List<String> getResultLines(ProcessInfo<ProcessResult, ProcessResult> processInfo) {
        String resultInfo = StringUtils.defaultString((String)((ProcessResult)processInfo.getStdOut()).toString()) + '\n' + StringUtils.defaultString((String)((ProcessResult)processInfo.getStdErr()).toString());
        return Arrays.asList(resultInfo.split("\n"));
    }

    private OsCommandExecutor() {
    }
}

