/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.file;

import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.migration.common.util.log.OperationLogger;
import com.huawei.migration.common.util.resource.PropertiesResourceUtil;
import com.huawei.migration.common.util.resource.ToolResourceGetter;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportFileUtil {
    private static final Logger log = LoggerFactory.getLogger(ExportFileUtil.class);
    public static final ExportFileUtil INSTANCE = new ExportFileUtil();

    public void exportFile(Window parentWindow, String title, Path filePath, String defaultPathId) {
        this.getFileSavePath(parentWindow, title, filePath.getFileName().toString(), defaultPathId).map(fileSavePath -> this.copyFile(filePath, (Path)fileSavePath)).ifPresent(exportSuccess -> this.showExportNotice(parentWindow, (boolean)exportSuccess));
    }

    public void exportFile(Window parentWindow, Path filePath, Path fileSavePath) {
        this.showExportNotice(parentWindow, this.copyFile(filePath, fileSavePath));
    }

    void showExportNotice(Window parentWindow, boolean exportSuccess) {
        DialogUtils.showInfoDialog((Window)parentWindow, (String)(exportSuccess ? PropertiesResourceUtil.getInnerMsg("tool.export.message.success") : PropertiesResourceUtil.getInnerMsg("tool.export.message.fail")));
    }

    private boolean copyFile(Path filePath, Path fileSavePath) {
        try {
            log.info("Export {} to {}.", (Object)filePath.getFileName(), (Object)fileSavePath);
            Files.copy(filePath, fileSavePath, StandardCopyOption.REPLACE_EXISTING);
            this.logExportOperation(filePath.getFileName().toString(), true);
            return true;
        }
        catch (IOException e) {
            log.error("Export file error.", (Throwable)e);
            this.logExportOperation(filePath.getFileName().toString(), false);
            return false;
        }
    }

    public void exportResource(Window parentWindow, String title, String resourceRelativePath, String defaultPathId) {
        String fileName = resourceRelativePath.substring(resourceRelativePath.lastIndexOf(47) + 1);
        this.getFileSavePath(parentWindow, title, fileName, defaultPathId).map(fileSavePath -> this.copyResource(resourceRelativePath, (Path)fileSavePath)).ifPresent(exportSuccess -> this.showExportNotice(parentWindow, (boolean)exportSuccess));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyResource(String resourceRelativePath, Path fileSavePath) {
        try (InputStream inputStream = ToolResourceGetter.getInputStream(resourceRelativePath);){
            log.info("Export {} to {}.", (Object)resourceRelativePath, (Object)fileSavePath);
            Files.copy(inputStream, fileSavePath, StandardCopyOption.REPLACE_EXISTING);
            this.logExportOperation(resourceRelativePath, true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error("Export resource {} error.", (Object)resourceRelativePath, (Object)e);
            this.logExportOperation(resourceRelativePath, false);
            return false;
        }
    }

    public Optional<Path> getFileSavePath(Window parentWindow, String title, String fileName, String defaultPathId) {
        String fileExtension = fileName.substring(fileName.lastIndexOf(46) + 1);
        return Optional.ofNullable(ToolFileChooser.getSaveFilePath((String)title, (String)fileExtension, (Window)parentWindow, (String)fileName, (String)defaultPathId)).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    void logExportOperation(String fileName, boolean success) {
        OperationLogger.clientLog("Export file.", fileName, success ? "SUCCESS" : "FAIL");
    }

    ExportFileUtil() {
    }
}

