/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRenameUtil {
    private static final Logger log = LoggerFactory.getLogger(FileRenameUtil.class);

    public static Path renameWhenDuplicate(Path parentDir, String fileName) {
        Path filePath = parentDir.resolve(fileName);
        if (Files.isDirectory(filePath, new LinkOption[0]) || !Files.exists(filePath, new LinkOption[0])) {
            return filePath;
        }
        return FileRenameUtil.rename(parentDir, fileName);
    }

    private static Path rename(Path parentDir, String fileName) {
        Path filePath;
        int index = 1;
        Set<Path> pathSet = FileRenameUtil.listParentDir(parentDir);
        do {
            filePath = parentDir.resolve(FileRenameUtil.getRenameFileName(fileName, index));
            ++index;
        } while (pathSet.contains(filePath));
        return filePath;
    }

    private static String getRenameFileName(String fileName, int index) {
        int pointIndex = fileName.lastIndexOf(46);
        pointIndex = pointIndex == -1 ? fileName.length() : pointIndex;
        return fileName.substring(0, pointIndex) + "(" + index + ")" + fileName.substring(pointIndex);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<Path> listParentDir(Path parentDir) {
        try (Stream<Path> pathStream = Files.list(parentDir);){
            Set<Path> set = pathStream.collect(Collectors.toSet());
            return set;
        }
        catch (IOException e) {
            log.error("List parent directory error.", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private FileRenameUtil() {
    }
}

