/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FilesHelper {
    public static void copy(Path sourcePath, Path targetDir) throws IOException {
        Path targetPath = targetDir.resolve(sourcePath.getFileName().toString());
        if (Files.isRegularFile(sourcePath, new LinkOption[0])) {
            FilesHelper.copyFile(sourcePath, targetPath);
        } else {
            FilesHelper.copyDir(sourcePath, Files.createDirectories(targetPath, new FileAttribute[0]));
        }
    }

    private static void copyDir(Path sourceDir, Path targetDir) throws IOException {
        try (Stream<Path> pathStream = Files.list(sourceDir);){
            List paths = pathStream.collect(Collectors.toList());
            for (Path path : paths) {
                Path targetPath = targetDir.resolve(path.getFileName().toString());
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    FilesHelper.copyFile(path, targetPath);
                    continue;
                }
                FilesHelper.copyDir(path, Files.createDirectories(targetPath, new FileAttribute[0]));
            }
        }
    }

    private static void copyFile(Path sourceFile, Path targetFile) throws IOException {
        Files.copy(sourceFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
    }

    private FilesHelper() {
    }
}

