/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.json;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.huawei.migration.common.util.json.adapter.GsonObjectTypeAdapter;
import com.huawei.migration.common.util.json.adapter.JsonExcludeAnnotationAdapter;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConverter {
    private static final Logger log = LoggerFactory.getLogger(JsonConverter.class);
    static final Gson GSON = JsonConverter.buildGson();

    private static Gson buildGson() {
        GsonObjectTypeAdapter adapter = new GsonObjectTypeAdapter();
        JsonExcludeAnnotationAdapter exclusionStrategy = new JsonExcludeAnnotationAdapter();
        return new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Map.class, (Object)adapter).registerTypeAdapter(List.class, (Object)adapter).registerTypeHierarchyAdapter(Path.class, (Object)new PathConverter()).addSerializationExclusionStrategy((ExclusionStrategy)exclusionStrategy).addDeserializationExclusionStrategy((ExclusionStrategy)exclusionStrategy).serializeNulls().setDateFormat("yyyy-MM-dd HH:mm:ss:SSS").create();
    }

    public static <T> Optional<T> deepClone(@Nullable T object, @NotNull Class<T> clazz) {
        return JsonConverter.fromJson(JsonConverter.toJson(object), clazz);
    }

    public static <T> Optional<T> fromJson(@Nullable String json, @NotNull Class<T> clazz) {
        try {
            return Optional.ofNullable(json).map(jsonStr -> GSON.fromJson(json, clazz));
        }
        catch (JsonSyntaxException e) {
            log.error("From json to parse object error.", (Throwable)e);
            return Optional.empty();
        }
    }

    public static <T> Optional<T> deepClone(@Nullable T object, @NotNull Type typeOfT) {
        return JsonConverter.fromJson(JsonConverter.toJson(object), typeOfT);
    }

    public static <T> Optional<T> fromJson(@Nullable String json, @NotNull Type typeOfT) {
        try {
            return Optional.ofNullable(json).map(jsonStr -> GSON.fromJson(jsonStr, typeOfT));
        }
        catch (JsonSyntaxException e) {
            log.error("From json to parse object error.", (Throwable)e);
            return Optional.empty();
        }
    }

    public static <T> String toJson(@Nullable T object) {
        return GSON.toJson(object);
    }

    private JsonConverter() {
    }

    private static class PathConverter
    implements JsonDeserializer<Path>,
    JsonSerializer<Path> {
        private PathConverter() {
        }

        public Path deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Paths.get(json.getAsString(), new String[0]);
        }

        public JsonElement serialize(Path src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }
}

