/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.json;

import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import com.huawei.migration.common.util.json.JsonConverter;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);

    @Deprecated
    public static <U> Optional<U> deepClone(U object, Class<U> clazz) {
        return JsonConverter.deepClone(object, clazz);
    }

    @Deprecated
    public static <U> Optional<U> fromJson(String json, Class<U> clazz) {
        return JsonConverter.fromJson(json, clazz);
    }

    @Deprecated
    public static String toJson(Object object) {
        return JsonConverter.toJson(object);
    }

    public static int safeGetInt(JSONObject json, String key) {
        return JsonUtil.safeGetInt(json, key, -1);
    }

    public static boolean safeGetBoolean(JSONObject jsonObject, String key) {
        try {
            return jsonObject.getBoolean(key);
        }
        catch (JSONException e) {
            log.error("safeGetBoolean error for key:{}", (Object)key);
            return false;
        }
    }

    public static String safeGetString(JSONObject jsonObject, String key) {
        return jsonObject.getStringOrDefault(key, "");
    }

    public static int safeGetInt(JSONObject jsonObject, String key, int defaultInt) {
        try {
            return jsonObject.getInt(key);
        }
        catch (JSONException e) {
            log.error("safeGetInt error for key:{}", (Object)key);
            return defaultInt;
        }
    }

    public static JSONObject safeGetJsonObject(JSONObject jsonObject, String key) {
        try {
            return jsonObject.getJSONObject(key);
        }
        catch (JSONException e) {
            log.error("safeGetJsonObject error for key: {}", (Object)key);
            return new JSONObject();
        }
    }

    public static JSONArray safeGetJsonArray(JSONObject jsonObject, String key) {
        try {
            return jsonObject.getJSONArray(key);
        }
        catch (JSONException e) {
            log.error("safeGetJsonArray error for key: {}", (Object)key);
            return new JSONArray();
        }
    }

    public static <U> List<U> parseObjFromJSONArray(JSONArray array, Function<JSONObject, U> parseFunction) {
        return IntStream.range(0, array.length()).mapToObj(arg_0 -> ((JSONArray)array).getJSONObject(arg_0)).map(parseFunction).collect(Collectors.toList());
    }

    private JsonUtil() {
    }
}

