/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.json.adapter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class GsonObjectTypeAdapter
extends TypeAdapter<Object> {
    private final TypeAdapter<Object> delegate = new Gson().getAdapter(Object.class);

    public void write(JsonWriter out, Object value) throws IOException {
        this.delegate.write(out, value);
    }

    public Object read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                return this.parseAsList(in);
            }
            case BEGIN_OBJECT: {
                return this.parseAsMap(in);
            }
            case STRING: {
                return in.nextString();
            }
            case NUMBER: {
                return this.parseNumber(in);
            }
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    private Object parseAsList(JsonReader in) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        in.beginArray();
        while (in.hasNext()) {
            list.add(this.read(in));
        }
        in.endArray();
        return list;
    }

    private Object parseAsMap(JsonReader in) throws IOException {
        LinkedTreeMap map = new LinkedTreeMap();
        in.beginObject();
        while (in.hasNext()) {
            map.put(in.nextName(), this.read(in));
        }
        in.endObject();
        return map;
    }

    private Object parseNumber(JsonReader in) throws IOException {
        String nextString = in.nextString();
        if (nextString.indexOf(46) != -1) {
            return Double.parseDouble(nextString);
        }
        long longValue = Long.parseLong(nextString);
        return longValue > Integer.MAX_VALUE ? longValue : (long)((int)longValue);
    }
}

