/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.log;

import com.huawei.migration.common.util.path.ToolPathUtil;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class OperationLogger {
    public static final String SUCCESS = "SUCCESS";
    public static final String FAIL = "FAIL";
    private static final String LOGGER_NAME = "operation_log";
    private static final String LOGGER_APPENDER_NAME = "operation_log_appender";
    private static final String OPERATION_LOG_LAYOUT_PATTERN = "%m%n";
    private static final String OPERATION_LOG_FILE_MAX_SIZE = "50M";
    private static final String OPERATION_LOG_FILE_MAX_NUM = "30";
    private static final String OPERATION_LOG_FILE_PATH = Paths.get(ToolPathUtil.ROOT_PATH, "log", "operationLog", "operationLog.log").toString();
    private static final String OPERATION_LOG_ROLLING_FILE_PATH = Paths.get(ToolPathUtil.ROOT_PATH, "log", "operationLog", "operationLog.%i.log.zip").toString();
    private static final String CLIENT_USER = System.getenv("USERNAME").trim();
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final Logger OPERATION_LOGGER = OperationLogger.getOperationLogger();

    public static void clientSuccessLog(String operation, String resource) {
        OperationLogger.clientLog(operation, resource, SUCCESS);
    }

    public static void clientFailLog(String operation, String resource) {
        OperationLogger.clientLog(operation, resource, FAIL);
    }

    public static void clientFailLog(String operation, String resource, String reason) {
        OperationLogger.failLog(CLIENT_USER, LOCAL_HOST, operation, resource, reason);
    }

    public static void clientLog(String operation, String resource, String result) {
        OperationLogger.log(CLIENT_USER, LOCAL_HOST, operation, resource, result);
    }

    public static void successLog(String user, String from, String operation, String resource) {
        OperationLogger.log(user, from, operation, resource, SUCCESS);
    }

    public static void failLog(String user, String from, String operation, String resource) {
        OperationLogger.log(user, from, operation, resource, FAIL);
    }

    public static void failLog(String user, String from, String operation, String resource, String reason) {
        OperationLog operationLog = new OperationLog(user, from, operation, resource, FAIL);
        operationLog.reason = reason;
        OPERATION_LOGGER.info((Object)operationLog);
    }

    public static void log(String user, String from, String operation, String resource, String result) {
        OPERATION_LOGGER.info((Object)new OperationLog(user, from, operation, resource, result));
    }

    private static Logger getOperationLogger() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Logger logger = LogManager.getLogger((String)LOGGER_NAME);
        Appender appender = loggerContext.getConfiguration().getAppender(LOGGER_APPENDER_NAME);
        if (logger == null || appender == null) {
            return OperationLogger.createLogger(loggerContext);
        }
        return logger;
    }

    private static Logger createLogger(LoggerContext loggerContext) {
        Configuration contextConfiguration = loggerContext.getConfiguration();
        RollingFileAppender operationLogAppender = OperationLogger.buildRollingFileAppender(contextConfiguration);
        contextConfiguration.addAppender((Appender)operationLogAppender);
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.ALL, (String)LOGGER_NAME, (String)"true", (AppenderRef[])OperationLogger.getAppenderRefs(), null, (Configuration)contextConfiguration, null);
        loggerConfig.addAppender((Appender)operationLogAppender, Level.ALL, null);
        contextConfiguration.addLogger(LOGGER_NAME, loggerConfig);
        loggerContext.updateLoggers();
        return LogManager.getLogger((String)LOGGER_NAME);
    }

    private static AppenderRef[] getAppenderRefs() {
        return new AppenderRef[]{AppenderRef.createAppenderRef((String)LOGGER_NAME, null, null)};
    }

    private static RollingFileAppender buildRollingFileAppender(Configuration contextConfiguration) {
        RollingFileAppender rollingFileAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFileName(OPERATION_LOG_FILE_PATH).withFilePattern(OPERATION_LOG_ROLLING_FILE_PATH).withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)OPERATION_LOG_FILE_MAX_SIZE)).withStrategy((RolloverStrategy)DefaultRolloverStrategy.newBuilder().withMax(OPERATION_LOG_FILE_MAX_NUM).build()).withAppend(true).setName(LOGGER_APPENDER_NAME)).setConfiguration(contextConfiguration)).setLayout(OperationLogger.getPatternLayout(contextConfiguration))).build();
        if (rollingFileAppender != null) {
            rollingFileAppender.start();
        }
        return rollingFileAppender;
    }

    private static Layout<String> getPatternLayout(Configuration contextConfiguration) {
        return PatternLayout.newBuilder().withConfiguration(contextConfiguration).withPattern(OPERATION_LOG_LAYOUT_PATTERN).withCharset(StandardCharsets.UTF_8).build();
    }

    private OperationLogger() {
    }

    private static class OperationLog {
        private final String time = LocalDateTime.now().toString();
        private final String user;
        private final String from;
        private final String operation;
        private final String resource;
        private final String result;
        private String reason = "";

        public String toString() {
            String prefix = "{\"time\":\"" + this.time + '\"' + ", \"user\":\"" + this.user + '\"' + ", \"from\":\"" + this.from + '\"' + ", \"operation\":\"" + this.operation + '\"' + ", \"resource\":\"" + this.resource + '\"' + ", \"result\":\"" + this.result + '\"';
            if (StringUtils.isEmpty((CharSequence)this.reason)) {
                return prefix + '}';
            }
            return prefix + ", \"reason\":\"" + this.reason + '\"' + '}';
        }

        public OperationLog(String user, String from, String operation, String resource, String result) {
            this.user = user;
            this.from = from;
            this.operation = operation;
            this.resource = resource;
            this.result = result;
        }

        public String getTime() {
            return this.time;
        }

        public String getUser() {
            return this.user;
        }

        public String getFrom() {
            return this.from;
        }

        public String getOperation() {
            return this.operation;
        }

        public String getResource() {
            return this.resource;
        }

        public String getResult() {
            return this.result;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

