/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.path;

import com.huawei.baize.base.string.StringFormatUtils;
import com.huawei.migration.common.exception.path.InvalidPathException;
import java.nio.file.Path;
import java.util.regex.Pattern;

public final class PathChecker {
    private static final Pattern INVALID_CHARACTER_PATTERN = Pattern.compile("[^\\w\\s\\\\/:-]+|\\s{2,}");

    public static void isValidPath(Path path) {
        if (PathChecker.isInvalid(path)) {
            throw new InvalidPathException(StringFormatUtils.format((String)"Current path [{}] is not valid,The path can contain only uppercase and lowercase letters, digits, hyphens (-), and underscores (_), and single space", (Object[])new Object[]{path}));
        }
    }

    private static boolean isInvalid(Path path) {
        return INVALID_CHARACTER_PATTERN.matcher(path.toString()).find();
    }

    private PathChecker() {
    }
}

