/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.path;

import com.huawei.migration.common.util.log.LogInfoSecurityTool;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolPathUtil {
    private static final Logger log = LoggerFactory.getLogger(ToolPathUtil.class);
    public static final String ROOT_PATH = ToolPathUtil.getRootPath() + File.separator;

    private static String getRootPath() {
        try {
            return new File("").getCanonicalPath();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static void makeDir(Path dirPath) {
        if (Files.exists(dirPath, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("makeDir error.", (Throwable)e);
        }
    }

    public static boolean checkFileExtension(Collection<String> extensionWhiteList, String fileName) {
        String fileExtension = FilenameUtils.getExtension((String)fileName);
        return extensionWhiteList.stream().anyMatch(fileExtension::equalsIgnoreCase);
    }

    public static Optional<String> normalizePath(@Nullable String originalPath) {
        try {
            if (originalPath == null) {
                return Optional.empty();
            }
            String path = Normalizer.normalize(originalPath, Normalizer.Form.NFKC);
            String realPath = new File(path).getCanonicalPath();
            if (realPath.equals(path)) {
                return Optional.of(realPath);
            }
            log.error("Invalid original path [{}].", (Object)LogInfoSecurityTool.cleanInvalidChar(originalPath));
            return Optional.empty();
        }
        catch (IOException e) {
            log.error("Get canonical path form original path [{}] error.", (Object)LogInfoSecurityTool.cleanInvalidChar(originalPath), (Object)e);
            return Optional.empty();
        }
    }

    private ToolPathUtil() {
    }
}

