/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.resource;

import com.huawei.migration.common.util.path.ToolPathUtil;
import com.huawei.migration.common.util.resource.ResourceBundleMgr;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesResourceUtil {
    private static final Logger log = LoggerFactory.getLogger(PropertiesResourceUtil.class);
    private static final Locale[] SUPPORTED_LANGUAGES = new Locale[]{Locale.CHINESE, Locale.ENGLISH};
    private static final String INNER_I18N_KEY = "config/languages/migration_common";
    private static final Map<String, ResourceBundleMgr> CUSTOM_LAN_PROPERTIES_MANAGERS = new HashMap<String, ResourceBundleMgr>();
    private static final Properties APPLICATION_PROPERTIES = new Properties();
    private static Locale currentLanguage = Locale.getDefault();

    private static void loadApplicationProperties() {
        Path applicationPropertiesPath = Paths.get(ToolPathUtil.ROOT_PATH, "configuration", "application.properties");
        if (Files.notExists(applicationPropertiesPath, new LinkOption[0])) {
            return;
        }
        try (InputStream inputStream = Files.newInputStream(applicationPropertiesPath, new OpenOption[0]);){
            APPLICATION_PROPERTIES.load(inputStream);
        }
        catch (IOException e) {
            log.error("Load application.properties error.", (Throwable)e);
        }
    }

    public static String getInnerMsg(String key, Object ... args) {
        String message = PropertiesResourceUtil.getInnerMsg(key);
        if (PropertiesResourceUtil.isMessageOrArgsInvalid(message, args)) {
            return message;
        }
        return MessageFormat.format(message, args);
    }

    public static String getInnerMsg(String key) {
        return PropertiesResourceUtil.getCustomMsg(INNER_I18N_KEY, key);
    }

    private static boolean isMessageOrArgsInvalid(String message, Object[] args) {
        return StringUtils.isEmpty((CharSequence)message) || "--".equals(message) || args == null || args.length == 0;
    }

    public static String getCustomMsg(String customLanKey, String messageKey, Object ... args) {
        return PropertiesResourceUtil.getCustomMsg(PropertiesResourceUtil.getCurrentLanguage(), customLanKey, messageKey, args);
    }

    public static String getCustomMsg(Locale language, String customLanKey, String messageKey, Object ... args) {
        String customMsg = PropertiesResourceUtil.getCustomMsg(language, customLanKey, messageKey);
        if (PropertiesResourceUtil.isMessageOrArgsInvalid(customMsg, args)) {
            return customMsg;
        }
        return MessageFormat.format(customMsg, args);
    }

    public static String getCustomMsg(String customLanKey, String messageKey) {
        return PropertiesResourceUtil.getCustomMsg(PropertiesResourceUtil.getCurrentLanguage(), customLanKey, messageKey);
    }

    public static String getCustomMsg(Locale language, String customLanKey, String messageKey) {
        if (StringUtils.isEmpty((CharSequence)customLanKey) || StringUtils.isEmpty((CharSequence)messageKey)) {
            log.error("The customLanKey [{}] or messageKey [{}] is null or empty.", (Object)customLanKey, (Object)messageKey);
            return "";
        }
        return PropertiesResourceUtil.getCustomLanPropertiesManager(customLanKey).getString(language, messageKey);
    }

    private static ResourceBundleMgr getCustomLanPropertiesManager(String customLanKey) {
        String validLanKey = PropertiesResourceUtil.getValidCustomLanKey(customLanKey);
        return CUSTOM_LAN_PROPERTIES_MANAGERS.computeIfAbsent(validLanKey, PropertiesResourceUtil::loadCustomLanPropertiesManager);
    }

    private static String getValidCustomLanKey(String customLanKey) {
        int index = 0;
        while (customLanKey.charAt(index) == '/') {
            ++index;
        }
        return customLanKey.substring(index);
    }

    private static ResourceBundleMgr loadCustomLanPropertiesManager(String customLanKey) {
        return new ResourceBundleMgr(customLanKey, PropertiesResourceUtil.getSupportedLanguages());
    }

    public static String getApplicationProperty(String key, String defaultValue) {
        return APPLICATION_PROPERTIES.getProperty(key, defaultValue);
    }

    public static Locale[] getSupportedLanguages() {
        return (Locale[])SUPPORTED_LANGUAGES.clone();
    }

    private PropertiesResourceUtil() {
    }

    public static Locale getCurrentLanguage() {
        return currentLanguage;
    }

    public static void setCurrentLanguage(Locale currentLanguage) {
        PropertiesResourceUtil.currentLanguage = currentLanguage;
    }

    static {
        PropertiesResourceUtil.loadApplicationProperties();
    }
}

