/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.resource;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleMgr {
    private static final Logger log = LoggerFactory.getLogger(ResourceBundleMgr.class);
    private final Map<String, ResourceBundle> resourceBundleMap = new HashMap<String, ResourceBundle>();

    public ResourceBundleMgr(String resourceBundleKey, Locale[] supportedLanguages) {
        for (Locale language : supportedLanguages) {
            try {
                this.resourceBundleMap.put(language.getLanguage(), ResourceBundle.getBundle(resourceBundleKey, language, ResourceBundleMgr.class.getClassLoader()));
            }
            catch (MissingResourceException e) {
                log.error("Failed to find resource bundle {} {}.", (Object)resourceBundleKey, (Object)language);
            }
        }
    }

    public String getString(Locale language, String key) {
        ResourceBundle resourceBundle = this.resourceBundleMap.get(language.getLanguage());
        if (resourceBundle == null) {
            log.error("no resource bundle for language: {}", (Object)language);
            return "--";
        }
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            log.error("no message for key: {}", (Object)key);
            return "--";
        }
    }
}

