/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolResourceGetter {
    private static final Logger log = LoggerFactory.getLogger(ToolResourceGetter.class);
    static final ImageIcon UNMATCHED_IMAGE = ToolResourceGetter.getImage("/config/base/images/none.png");
    private static final String IMAGES_DEFAULT_DIR = "config/images/";
    private static final Map<String, String> RESOURCE_SHA256_CACHE = new ConcurrentHashMap<String, String>();

    @NotNull
    public static String getResourceSha256(@NotNull String resourceRelativePath, boolean isText) {
        return RESOURCE_SHA256_CACHE.computeIfAbsent(resourceRelativePath, path -> ToolResourceGetter.getSha256(path, isText));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getSha256(String resourceRelativePath, boolean isText) {
        if (isText) {
            return DigestUtils.sha256Hex((String)String.join((CharSequence)"\n", ToolResourceGetter.readLines(resourceRelativePath)));
        }
        try (InputStream inputStream = ToolResourceGetter.getInputStream(resourceRelativePath);){
            String string = DigestUtils.sha256Hex((InputStream)inputStream);
            return string;
        }
        catch (IOException e) {
            log.error("Get resource SHA256 error.", (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLines(String resourceRelativePath) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ToolResourceGetter.getInputStream(resourceRelativePath), StandardCharsets.UTF_8));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            log.error("Read resource '{}' lines error.", (Object)resourceRelativePath, (Object)e);
            return Collections.emptyList();
        }
    }

    public static InputStream getInputStream(String resourceRelativePath) throws IOException {
        return ToolResourceGetter.getUrl(resourceRelativePath).openStream();
    }

    public static ImageIcon getImage(String imageFileName) {
        if (StringUtils.isEmpty((CharSequence)imageFileName)) {
            return UNMATCHED_IMAGE;
        }
        try {
            return new ImageIcon(ToolResourceGetter.getImageUrl(imageFileName));
        }
        catch (IOException e) {
            log.error("Get image '{}' fail. Return UNMATCHED_IMAGE.", (Object)imageFileName);
            return UNMATCHED_IMAGE;
        }
    }

    private static URL getImageUrl(String imageFileName) throws IOException {
        String imageRelativePath = ToolResourceGetter.getImageRelativePath(imageFileName);
        try {
            return ToolResourceGetter.getUrl(imageRelativePath);
        }
        catch (IOException e) {
            log.error("Failed to get image url from '{}', try get url from '{}' directly.", (Object)imageRelativePath, (Object)imageFileName);
            return ToolResourceGetter.getUrl(imageFileName);
        }
    }

    private static String getImageRelativePath(String imageFileName) {
        return imageFileName.charAt(0) == '/' ? imageFileName : IMAGES_DEFAULT_DIR + imageFileName;
    }

    public static URL getUrl(String resourceRelativePath) throws IOException {
        return Optional.of(ToolResourceGetter.resolveRelativePath(resourceRelativePath)).map(ToolResourceGetter::getResource).orElseThrow(() -> new IOException("Get resource '" + resourceRelativePath + "' url fail."));
    }

    private static URL getResource(String resolvedRelativePath) {
        return Optional.ofNullable(ToolResourceGetter.class.getClassLoader()).map(classLoader -> classLoader.getResource(resolvedRelativePath)).orElseGet(() -> ClassLoader.getSystemResource(resolvedRelativePath));
    }

    private static String resolveRelativePath(String resourceRelativePath) throws IOException {
        if (StringUtils.isEmpty((CharSequence)resourceRelativePath)) {
            throw new IOException("The resource path '" + resourceRelativePath + "' cannot be null or empty.");
        }
        return resourceRelativePath.startsWith("/") ? resourceRelativePath.substring(1) : resourceRelativePath;
    }

    private ToolResourceGetter() {
    }
}

