/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.serializer;

import com.huawei.migration.common.util.data.ObjectClassConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectSerializer {
    private static final Logger log = LoggerFactory.getLogger(ObjectSerializer.class);

    public static void serialize(@NotNull Serializable serializable, @NotNull Path filePath) {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));){
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            log.info("write file success.");
        }
        catch (IOException exception) {
            log.error("write file failed.", (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> Optional<T> deSerialize(@NotNull Class<T> clazz, @NotNull Path filePath, @NotNull Predicate<ObjectStreamClass> checker) {
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            return Optional.empty();
        }
        try (SerializeInputStream objectInputStream = new SerializeInputStream(Files.newInputStream(filePath, new OpenOption[0]), checker);){
            Optional<T> optional = ObjectClassConverter.convert(objectInputStream.readObject(), clazz);
            return optional;
        }
        catch (IOException | ClassNotFoundException exception) {
            log.error("parse object error.", (Throwable)exception);
            return Optional.empty();
        }
    }

    private ObjectSerializer() {
    }

    private static final class SerializeInputStream
    extends ObjectInputStream {
        private final Predicate<ObjectStreamClass> checker;

        public SerializeInputStream(@NotNull InputStream in, @NotNull Predicate<ObjectStreamClass> checker) throws IOException {
            super(in);
            this.checker = checker;
        }

        @Override
        protected Class<?> resolveClass(@NotNull ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.checker.test(desc)) {
                return super.resolveClass(desc);
            }
            throw new ClassNotFoundException(desc.getName());
        }
    }
}

