/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.thread;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PeriodExecuteScheduler {
    private final Runnable runnable;
    private final long period;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private boolean alreadyStarted = false;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);

    public void start() {
        if (this.alreadyStarted) {
            throw new RejectedExecutionException("Scheduler has been started.");
        }
        this.scheduler.scheduleAtFixedRate(this.runnable, 0L, this.period, this.timeUnit);
        this.alreadyStarted = true;
    }

    public void stop() {
        this.scheduler.shutdown();
    }

    public PeriodExecuteScheduler(Runnable runnable, long period) {
        this.runnable = runnable;
        this.period = period;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }
}

