/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.thread;

import com.huawei.migration.common.util.thread.ThreadPoolFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubtaskAsyncExecutor {
    private static final Logger log = LoggerFactory.getLogger(SubtaskAsyncExecutor.class);
    private final ExecutorService asyncExecutor;

    public SubtaskAsyncExecutor(int threadNum) {
        this(threadNum, "subtask_async_exec_thread");
    }

    public SubtaskAsyncExecutor(int threadNum, String threadPoolName) {
        this.asyncExecutor = ThreadPoolFactory.newFixedThreadPool(threadNum, threadPoolName);
    }

    public <V> void executeAndCallback(Supplier<V> supplier, Consumer<V> callback, Consumer<Throwable> exceptionally) {
        this.asyncExecuteAndCallback(supplier, callback, exceptionally).join();
    }

    public <V> CompletableFuture<Void> asyncExecuteAndCallback(Supplier<V> supplier, Consumer<V> callback, Consumer<Throwable> exceptionally) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(supplier, this.getAsyncExecutor()).thenAccept((Consumer)callback)).exceptionally(throwable -> {
            exceptionally.accept((Throwable)throwable);
            return null;
        });
    }

    public void runAsync(Runnable runnable) {
        CompletableFuture.runAsync(runnable, this.getAsyncExecutor());
    }

    public <V> CompletableFuture<V> supplyAsync(Supplier<V> supplier) {
        return CompletableFuture.supplyAsync(supplier, this.getAsyncExecutor());
    }

    public ExecutorService getAsyncExecutor() {
        return this.asyncExecutor;
    }
}

