/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.thread;

import com.huawei.migration.common.util.thread.ThreadPoolFactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubtaskBatchExecutor {
    private static final Logger log = LoggerFactory.getLogger(SubtaskBatchExecutor.class);
    private final ExecutorService batchExecutor;

    public SubtaskBatchExecutor(int threadNum) {
        this(threadNum, "subtask_batch_exec_thread");
    }

    public SubtaskBatchExecutor(int threadNum, String threadPoolName) {
        this.batchExecutor = ThreadPoolFactory.newFixedThreadPool(threadNum, threadPoolName);
    }

    public boolean isAllExecuteSuccess(List<Callable<Boolean>> callables) {
        return this.batchExecute(callables).stream().allMatch(Boolean.TRUE::equals);
    }

    public <V> List<V> batchExecute(List<Callable<V>> callables) {
        return this.batchSupply(this.toSuppliers(callables));
    }

    private <V> List<Supplier<V>> toSuppliers(List<Callable<V>> callables) {
        return callables.stream().map(this::toSupplier).collect(Collectors.toList());
    }

    private <V> Supplier<V> toSupplier(Callable<V> callable) {
        return () -> this.handleCallableException(callable).orElse(null);
    }

    private <V> Optional<V> handleCallableException(Callable<V> callable) {
        try {
            return Optional.ofNullable(callable.call());
        }
        catch (Exception e) {
            log.error("Call subtask error.", (Throwable)e);
            return Optional.empty();
        }
    }

    public boolean isAllSupplySuccess(List<Supplier<Boolean>> suppliers) {
        return this.batchSupply(suppliers).stream().allMatch(Boolean.TRUE::equals);
    }

    public <V> List<V> batchSupply(List<Supplier<V>> suppliers) {
        if (suppliers.isEmpty()) {
            return Collections.emptyList();
        }
        List<CompletableFuture<V>> completableFutures = this.getCompletableFutures(suppliers);
        ((CompletableFuture)CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).exceptionally(this::handleFutureException)).join();
        return this.getCompletableFuturesResults(completableFutures);
    }

    private Void handleFutureException(Throwable throwable) {
        log.error("Batch execute subtasks error.", throwable);
        return null;
    }

    private <V> List<CompletableFuture<V>> getCompletableFutures(List<Supplier<V>> suppliers) {
        return suppliers.stream().map(supplier -> CompletableFuture.supplyAsync(supplier, this.batchExecutor)).collect(Collectors.toList());
    }

    private <V> List<V> getCompletableFuturesResults(List<CompletableFuture<V>> completableFutures) {
        return completableFutures.stream().map(completableFuture -> this.getCompletableFutureResult((CompletableFuture)completableFuture).orElse(null)).collect(Collectors.toList());
    }

    private <V> Optional<V> getCompletableFutureResult(CompletableFuture<V> completableFuture) {
        try {
            return Optional.ofNullable(completableFuture.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Get CompletableFuture result interrupt error.", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("Get CompletableFuture result execution error.", (Throwable)e);
        }
        return Optional.empty();
    }

    public SubtaskBatchExecutor(ExecutorService batchExecutor) {
        this.batchExecutor = batchExecutor;
    }

    public ExecutorService getBatchExecutor() {
        return this.batchExecutor;
    }
}

