/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolFactory {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolFactory.class);

    public static ExecutorService newFixedThreadPool(int threadNum, @NonNull String threadName) {
        if (threadName == null) {
            throw new NullPointerException("threadName is marked non-null but is null");
        }
        log.info("create thread pool {} with {} threads.", (Object)threadName, (Object)threadNum);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadNum, threadNum, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), ThreadPoolFactory.getThreadFactory(threadName));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    private static ThreadFactory getThreadFactory(String threadName) {
        AtomicInteger threadNumber = new AtomicInteger(1);
        return runnable -> {
            Thread thread = new Thread(runnable);
            thread.setUncaughtExceptionHandler(ThreadPoolFactory.getUncaughtExceptionHandler());
            thread.setName(threadName + "_" + threadNumber.getAndIncrement());
            return thread;
        };
    }

    private static Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return (thread, exception) -> log.error("Thread {} exception occurred.", (Object)thread.getName(), (Object)exception);
    }

    private ThreadPoolFactory() {
    }
}

