/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.verify;

import com.google.common.base.Strings;
import com.huawei.encryptbase.asymmetric.AsymmetricSignTool;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LicenseDataParser {
    private static final Logger log = LoggerFactory.getLogger(LicenseDataParser.class);
    private static final String PUBLIC_KEY = "MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAh4j5jh/AkAY1eYSmqmKoOyOUZYYRR3UarWw+ljNhm421ujGuIXw/Q8iD7dN4+yh20F6vTCujGc9b7JTuM3YYS4RArK8PPu6aG9a5KVeK/RBFZ93E54EsYd0rhBIr9d7k/e/6Hc3Qwx9HD+xQZoZA61JNDJ64cjoTB3wwFO8Rz7CzPNQn8hWX8o463qmZNclWWfYO2hmXOfERXQgfu+YGLs875eFw66IQrSTqcM6lRqIh1sWBsFyrOPoZy3zAwI/lcYrAnIMDFl57s9c/bQM3wyiuHvQyY1OGwjKGsVbUuoj1F6nqHRb4bZ1iFKjQ0O+Er+EbbJloJNKvmRflq7Y2LQuzfxcB/1QfVGME5ItiQBnQdwBzKlS0buo+EkCo66+GEmB1zwf36QkSD2nzoGbwxEPma93rRjO+x1tI4zRkPoRH2i29nzjqwYiUxYPWOpLGrJRdCru8KqXL0NgyWDHXnCj9Da4GaVCTz3o/ZGaer0m9ctY7kA2pxnivUsXj/h6yhAAFxKFvvYDzbFZDIJpRXDZ7IMr75n3hyYp8tH0WItu08b5HIN8/l19fCeo/wCK9iAvxYlodQKCTKDLqqRYW51zzQ5oMHLe5r1qEGmaMJb0qqZGZOsfNMzLfkETKtveCtU4YnHQbUN6CfyYIsm4zuMZrz9diQRQVoCz3W8K3LIECAwEAAQ==";

    @NotNull
    public static String parseLicenseData(Path licenseFilePath) {
        return LicenseDataParser.parseLicenseData(LicenseDataParser.readLicense(licenseFilePath));
    }

    @NotNull
    public static String parseLicenseData(List<String> licenseContent) {
        if (licenseContent.size() != 2) {
            return "";
        }
        byte[] licenseData = Base64.getDecoder().decode(licenseContent.get(0));
        return LicenseDataParser.verifySignature(licenseData, licenseContent.get(1)) ? new String(licenseData, StandardCharsets.UTF_8) : "";
    }

    private static boolean verifySignature(byte[] licenseData, String licenseSignature) {
        return AsymmetricSignTool.verifyRsaSignature((Object)licenseData, (String)licenseSignature, (String)PUBLIC_KEY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> readLicense(Path licenseFilePath) {
        try (Stream<String> lines = Files.lines(licenseFilePath);){
            List<String> list = lines.filter(line -> !Strings.isNullOrEmpty((String)line)).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            log.error("Read license file data error.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private LicenseDataParser() {
    }
}

