/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.verify;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class OsCommandVerifier {
    private static final Set<Integer> SPECIAL_CHARS = IntStream.of(124, 59, 38, 36, 62, 60, 96, 33, 10).boxed().collect(Collectors.toSet());

    public static boolean isParamValid(String param) {
        return param.chars().noneMatch(SPECIAL_CHARS::contains);
    }

    public static boolean isCommandValid(String command) {
        return OsCommandVerifier.isCommandValid(command, Collections.emptyList());
    }

    public static boolean isCommandValid(String command, @NotNull Collection<AllowedSpecialChar> allowedSpecialChars) {
        if (OsCommandVerifier.isCommandContainsSpecialChar(command, allowedSpecialChars)) {
            return false;
        }
        return allowedSpecialChars.stream().allMatch(allowedSpecialChar -> ((AllowedSpecialChar)allowedSpecialChar).isAllowed(command));
    }

    private static boolean isCommandContainsSpecialChar(String command, Collection<AllowedSpecialChar> allowedSpecialChars) {
        Set<Integer> notAllowedChars = OsCommandVerifier.getNotAllowedChars(allowedSpecialChars);
        return command.chars().anyMatch(notAllowedChars::contains);
    }

    private static Set<Integer> getNotAllowedChars(Collection<AllowedSpecialChar> allowedSpecialChars) {
        HashSet<Integer> specialChars = new HashSet<Integer>(SPECIAL_CHARS);
        allowedSpecialChars.stream().mapToInt(allowedSpecialChar -> ((AllowedSpecialChar)allowedSpecialChar).specialChar).forEach(specialChars::remove);
        return specialChars;
    }

    private OsCommandVerifier() {
    }

    public static class AllowedSpecialChar {
        private final char specialChar;
        private final int allowedCount;
        @NotNull
        private final String allowedWithWord;

        private boolean isAllowed(String command) {
            if (!this.allowedWithWord.isEmpty() && !command.contains(this.allowedWithWord)) {
                return false;
            }
            return this.countSpecialChar(command) <= (long)this.allowedCount;
        }

        private long countSpecialChar(String command) {
            return command.codePoints().filter(codePoint -> codePoint == this.specialChar).count();
        }

        public AllowedSpecialChar(char specialChar, int allowedCount, @NotNull String allowedWithWord) {
            if (allowedWithWord == null) {
                throw new NullPointerException("allowedWithWord is marked non-null but is null");
            }
            this.specialChar = specialChar;
            this.allowedCount = allowedCount;
            this.allowedWithWord = allowedWithWord;
        }
    }
}

