/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.verify;

import com.huawei.migration.common.util.verify.Sha256VerifiableResource;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSha256Verifier {
    private static final Logger log = LoggerFactory.getLogger(ResourceSha256Verifier.class);

    public static boolean verify(@NotNull Collection<? extends Sha256VerifiableResource> resources) {
        return resources.stream().filter(resource -> !ResourceSha256Verifier.verify(resource)).count() <= 0L;
    }

    private static boolean verify(Sha256VerifiableResource resource) {
        if (resource.verify()) {
            return true;
        }
        log.error("Verify resource '{}' SHA256 fail. Actual SAH256: {}", (Object)resource.getPath(), (Object)resource.calculateSha256());
        return !resource.isInterceptWhenIncomplete();
    }

    private ResourceSha256Verifier() {
    }
}

