/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.verify;

import com.huawei.migration.common.util.path.ToolPathUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ToolRunningFlagFileLocker {
    private static final Logger log = LoggerFactory.getLogger(ToolRunningFlagFileLocker.class);
    static final Path RUNNING_FLAG_FILE_PATH = Paths.get(ToolPathUtil.ROOT_PATH, "runningFlag");
    static final ToolRunningFlagFileLocker LOCKER = new ToolRunningFlagFileLocker();
    private FileOutputStream fileOutputStream;
    private FileChannel fileChannel;

    ToolRunningFlagFileLocker() {
    }

    boolean tryLock() {
        try {
            this.fileChannel = this.openFileChannel();
            return this.fileChannel.tryLock() != null;
        }
        catch (Exception e) {
            log.error("Lock tool running flag file error.", (Throwable)e);
            return false;
        }
    }

    private FileChannel openFileChannel() throws IOException {
        if (Files.notExists(RUNNING_FLAG_FILE_PATH, new LinkOption[0])) {
            Files.createFile(RUNNING_FLAG_FILE_PATH, new FileAttribute[0]);
        }
        this.fileOutputStream = new FileOutputStream(RUNNING_FLAG_FILE_PATH.toFile());
        return this.fileOutputStream.getChannel();
    }

    void release() {
        try {
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
            if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
            }
        }
        catch (IOException e) {
            log.error("Release running flag file lock error.", (Throwable)e);
        }
    }
}

