/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migration.common.util.verify;

import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.migration.common.ui.dialog.ShowHelpLinkDialog;
import com.huawei.migration.common.util.encrypt.ToolEncryptor;
import com.huawei.migration.common.util.path.ToolPathUtil;
import com.huawei.migration.common.util.resource.PropertiesResourceUtil;
import com.huawei.migration.common.util.verify.ToolRunningFlagFileLocker;
import java.io.File;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolWorkEnvironmentVerifier {
    private static final Logger log = LoggerFactory.getLogger(ToolWorkEnvironmentVerifier.class);
    static final Pattern INVALID_CHARACTER_PATTERN = Pattern.compile("([^\\w\\s.()-]+)|(\\s{2,})");

    public static boolean verifyWorkingEnvironment(String kmcSection, Runnable openKmcSectionAction, Stream<String> configFileRelativePathStream) {
        return ToolWorkEnvironmentVerifier.isWorkingPathValid() && ToolWorkEnvironmentVerifier.isToolCanRun() && ToolWorkEnvironmentVerifier.isKmcWorkingNormally(kmcSection, openKmcSectionAction) && ToolWorkEnvironmentVerifier.isAllConfigFileCompletes(configFileRelativePathStream);
    }

    private static boolean isWorkingPathValid() {
        String path = ToolPathUtil.ROOT_PATH.replaceAll("[\\\\/:]", "");
        if (!INVALID_CHARACTER_PATTERN.matcher(path).find()) {
            return true;
        }
        log.error("The tool path has invalid characters.");
        DialogUtils.showInfoDialog((JDialog)new JDialog(), (String)PropertiesResourceUtil.getInnerMsg("tool.work.path.invalid"));
        return false;
    }

    private static boolean isToolCanRun() {
        if (ToolRunningFlagFileLocker.LOCKER.tryLock()) {
            return true;
        }
        log.info("The tool is running.");
        DialogUtils.showInfoDialog((JDialog)new JDialog(), (String)PropertiesResourceUtil.getInnerMsg("tool.already.running"));
        ToolRunningFlagFileLocker.LOCKER.release();
        return false;
    }

    private static boolean isKmcWorkingNormally(String kmcSection, Runnable openKmcSectionAction) {
        if (ToolWorkEnvironmentVerifier.isKmcEncryptionAndDecryptionWorking()) {
            return true;
        }
        log.error("Check KMC running environment fail.");
        new ShowHelpLinkDialog(null, PropertiesResourceUtil.getInnerMsg("tool.verify.kmc.fail.msg"), kmcSection, openKmcSectionAction);
        return false;
    }

    private static boolean isKmcEncryptionAndDecryptionWorking() {
        String original = "*";
        String encrypt = ToolEncryptor.encrypt("*");
        return !encrypt.isEmpty() && "*".equals(ToolEncryptor.decrypt(encrypt));
    }

    private static boolean isAllConfigFileCompletes(Stream<String> configFileRelativePathStream) {
        if (ToolWorkEnvironmentVerifier.verifyConfigFiles(configFileRelativePathStream)) {
            return true;
        }
        DialogUtils.showInfoDialog((JDialog)new JDialog(), (String)PropertiesResourceUtil.getInnerMsg("tool.verify.file.fail.msg"));
        return false;
    }

    private static boolean verifyConfigFiles(Stream<String> configFileRelativePathStream) {
        return configFileRelativePathStream.map(relativePath -> new File(ToolPathUtil.ROOT_PATH, (String)relativePath)).filter(ToolWorkEnvironmentVerifier::isConfigFileModified).count() <= 0L;
    }

    private static boolean isConfigFileModified(File configFile) {
        try {
            if (SHAAndRSAVerifyUtils.getInstance().excuteVerify(configFile)) {
                return false;
            }
            log.error("Verify resource file {} sign fail. The file is modified.", (Object)configFile.getName());
        }
        catch (Exception e) {
            log.error("Verify resource file {} sign error.", (Object)configFile.getName(), (Object)e);
        }
        return true;
    }

    private ToolWorkEnvironmentVerifier() {
    }
}

