/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.asymmetric;

import com.huawei.encryptbase.asymmetric.AsymmetricCipherAlgorithm;
import com.huawei.encryptbase.asymmetric.AsymmetricKeyAlgorithm;
import com.huawei.encryptbase.asymmetric.AsymmetricKeyConverter;
import com.huawei.encryptbase.exception.ProcessEncryptException;
import com.huawei.encryptbase.utils.InputParamValidator;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsymmetricEncryptTool {
    private static final Logger log = LoggerFactory.getLogger(AsymmetricEncryptTool.class);

    private AsymmetricEncryptTool() {
    }

    public static String encrypt(byte[] plaintext, PublicKey publicKey, String algorithm) {
        AsymmetricEncryptTool.checkEncryptInputParam(plaintext, publicKey, algorithm);
        try {
            IESParameterSpec spec = new IESParameterSpec(null, null, 128);
            Cipher cipher = Cipher.getInstance(algorithm, "BC");
            cipher.init(1, (Key)publicKey, (AlgorithmParameterSpec)spec, SecureRandom.getInstanceStrong());
            return Base64.encodeBase64String((byte[])cipher.doFinal(plaintext));
        }
        catch (Exception e) {
            throw new ProcessEncryptException("Process encrypt error.", e);
        }
    }

    private static void checkEncryptInputParam(byte[] plaintext, PublicKey publicKey, String algorithm) {
        InputParamValidator.checkByteInput(plaintext);
        InputParamValidator.checkInputPublicKey(publicKey);
        InputParamValidator.checkInputStr(algorithm);
    }

    public static String decrypt(byte[] cipher, PrivateKey privateKey, String algorithm) {
        AsymmetricEncryptTool.checkDecryptInputParam(cipher, privateKey, algorithm);
        try {
            IESParameterSpec spec = new IESParameterSpec(null, null, 128);
            Cipher iesCipher = Cipher.getInstance(algorithm, "BC");
            iesCipher.init(2, (Key)privateKey, (AlgorithmParameterSpec)spec, SecureRandom.getInstanceStrong());
            return Base64.encodeBase64String((byte[])iesCipher.doFinal(cipher));
        }
        catch (Exception e) {
            throw new ProcessEncryptException("Process decrypt error.", e);
        }
    }

    private static void checkDecryptInputParam(byte[] cipher, PrivateKey privateKey, String algorithm) {
        InputParamValidator.checkByteInput(cipher);
        InputParamValidator.checkInputPrivateKey(privateKey);
        InputParamValidator.checkInputStr(algorithm);
    }

    public static String encryptByEcies(byte[] plaintext, PublicKey publicKey) {
        return AsymmetricEncryptTool.encrypt(plaintext, publicKey, AsymmetricCipherAlgorithm.ECIES.getAlgorithm());
    }

    public static String encryptByEcies(byte[] plaintext, String publicKey) {
        return AsymmetricEncryptTool.encryptByEcies(plaintext, AsymmetricKeyConverter.convertToPublicKey(publicKey, AsymmetricKeyAlgorithm.EC));
    }

    public static String decryptByEcies(byte[] cipher, PrivateKey privateKey) {
        return AsymmetricEncryptTool.decrypt(cipher, privateKey, AsymmetricCipherAlgorithm.ECIES.getAlgorithm());
    }

    public static String decryptByEcies(byte[] cipher, String privateKey) {
        return AsymmetricEncryptTool.decrypt(cipher, AsymmetricKeyConverter.convertToPrivateKey(privateKey, AsymmetricKeyAlgorithm.EC), AsymmetricCipherAlgorithm.ECIES.getAlgorithm());
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

