/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.clear;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainSensitiveDataClearTool {
    private static final Logger log = LoggerFactory.getLogger(PlainSensitiveDataClearTool.class);
    private static final PlainSensitiveDataClearTool INSTANCE = new PlainSensitiveDataClearTool();

    private PlainSensitiveDataClearTool() {
    }

    public static PlainSensitiveDataClearTool getInstance() {
        return INSTANCE;
    }

    @Deprecated
    public void clearPlainSensitiveData(String plainSensitiveDataStr) {
        if (StringUtils.isBlank((CharSequence)plainSensitiveDataStr)) {
            return;
        }
        try {
            Field field = plainSensitiveDataStr.getClass().getDeclaredField("value");
            field.setAccessible(true);
            char[] cipherTmpArr = (char[])field.get(plainSensitiveDataStr);
            this.clearPlainSensitiveData(cipherTmpArr);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error("getDeclaredField value error", (Throwable)e);
        }
        catch (Exception e) {
            log.error("the java may not support this usage.", (Throwable)e);
        }
    }

    public void clearPlainSensitiveData(byte[] plainSensitiveDataByteArr) {
        Arrays.fill(plainSensitiveDataByteArr, (byte)0);
    }

    public void clearPlainSensitiveData(char[] plainSensitiveDataCharArr) {
        Arrays.fill(plainSensitiveDataCharArr, '0');
    }
}

