/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common;

import com.huawei.uMate.common.GlobalStaticValue;
import com.huawei.uMate.common.internationalization.CommonEnum;
import com.huawei.uMate.common.log.Logger;
import com.huawei.uMate.common.utils.SecurityUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class SystemConfig {
    private static final Logger LOGGER = new Logger(SystemConfig.class);
    Properties prop = null;
    private String filename = null;
    private static SystemConfig config = null;

    public static synchronized SystemConfig createSystemConfig() {
        if (null != config) {
            return config;
        }
        config = new SystemConfig();
        return config;
    }

    private SystemConfig() {
        FileInputStream fileInputStream = null;
        try {
            this.filename = GlobalStaticValue.COMMON_BUNDLE.getValue((Object)CommonEnum.CommonResourcesEnum.SystemConfigFile);
            fileInputStream = FileUtils.openInputStream(FileUtils.getFile(this.filename));
            this.prop = new Properties();
            this.prop.load(fileInputStream);
        }
        catch (IOException ex) {
            LOGGER.error(ex);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ex) {
                    LOGGER.error(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemConfig(String cfg) {
        FileInputStream inputStream = null;
        try {
            if (cfg == null) {
                return;
            }
            inputStream = FileUtils.openInputStream(FileUtils.getFile(cfg));
            this.filename = cfg;
            this.prop = new Properties();
            this.prop.load(inputStream);
        }
        catch (IOException ex) {
            LOGGER.error(ex);
            this.prop = new Properties();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    LOGGER.error(ex);
                }
            }
        }
        this.prop.list(System.out);
    }

    public void SaveCfg() throws FileNotFoundException, IOException {
        FileOutputStream outputFile = null;
        try {
            outputFile = new FileOutputStream(this.filename);
            this.prop.store(outputFile, "save config");
        }
        finally {
            if (null != outputFile) {
                try {
                    outputFile.close();
                }
                catch (IOException ex) {
                    LOGGER.error(ex);
                }
            }
        }
    }

    public String getConfigVlaue(String configName) {
        String value = this.prop.getProperty(configName);
        if (null == value) {
            return null;
        }
        return value.trim();
    }

    public void setConfigVlaue(String configName, String configValue) {
        this.prop.setProperty(configName, configValue);
    }

    public int getIntConfigValue(String configName, int defaultValue) {
        String value = this.getConfigVlaue(configName);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        if (!SecurityUtils.isValidAndSafeNumber(value, false)) {
            return defaultValue;
        }
        try {
            int v = Integer.parseInt(value);
            return v;
        }
        catch (NumberFormatException ex) {
            LOGGER.error(String.format(Locale.ROOT, "%s value(%s) is not a number, will use(%s) replace.", configName, value, defaultValue));
            return defaultValue;
        }
    }
}

