/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.log;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import org.apache.log4j.Level;

public class Logger {
    private org.slf4j.Logger logger;
    private static boolean isInfoEnabled = true;
    private static final String FQCN = Logger.class.getName();

    public Logger(Class<?> clazz) {
        this.logger = ToolLoggerFactory.getLogger(clazz);
    }

    public Logger(String className) {
        this.logger = ToolLoggerFactory.getLoggerInStandAlone((String)"umate");
    }

    private Logger() {
        this.logger = ToolLoggerFactory.getLoggerInStandAlone((String)"umate");
    }

    public void debug(Object message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message.toString());
        }
    }

    public void info(Object message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message.toString());
        }
    }

    public void infoDefault(Object message, String ... msgParams) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((String)message, msgParams);
        }
    }

    public void warnDefault(Object message, String ... msgParams) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((String)message, msgParams);
        }
    }

    public void errorDefault(String message, Throwable t, String ... msgParams) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message, (Object)msgParams, (Object)t);
        }
    }

    public void warn(Object message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((String)message);
        }
    }

    public void error(Object message) {
        if (this.logger.isErrorEnabled() && message instanceof String) {
            this.logger.error((String)message);
        }
    }

    public void error(String message, Throwable ex) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message, ex);
        }
    }

    public void assertLog(boolean assertion, String message) {
        if (!assertion) {
            Logger.forcedLog(this.logger, Level.ERROR, message);
        }
    }

    private static void forcedLog(org.slf4j.Logger logger, Level level, Object message) {
        logger.info(FQCN, level, message, null);
    }

    public static synchronized boolean isInfoEnabled() {
        return isInfoEnabled;
    }
}

