/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.util;

import com.huawei.ism.tool.exttool.entity.Tool;
import com.huawei.ism.tool.framework.platform.common.tool.Field;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.io.File;
import java.util.List;

public final class ToolStatusChecker {
    private static final String TOOL_LOCKED_FLAG = "lockFlag";
    private static final String STORAGE = "storage";

    private ToolStatusChecker() {
    }

    public static boolean isToolLocked(String toolId) {
        String locFilePath = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getWorkPath() + File.separator + "tools" + File.separator + toolId + File.separator + TOOL_LOCKED_FLAG;
        File locFile = new File(locFilePath);
        return locFile.exists() && !locFile.delete();
    }

    public static boolean isToolRunning(String toolId) {
        return ApplicationContext.getInstance().isToolRunning(toolId, "runningFlag");
    }

    public static boolean isBackToolRunning(String toolId) {
        return ApplicationContext.getInstance().isToolRunning(toolId, "backFlag");
    }

    public static boolean checkCannotRunningTool(String toolId, Field field, List<Tool> allTools) {
        if (ToolStatusChecker.hasCurToolRunning(toolId, allTools)) {
            return true;
        }
        if (ToolStatusChecker.hasBackToolRunning(allTools)) {
            return true;
        }
        return ToolStatusChecker.isNotCanRunTool(field, allTools);
    }

    private static boolean isNotCanRunTool(Field field, List<Tool> allTools) {
        for (Tool tool : allTools) {
            if (!tool.getRunningByBackend() && ApplicationContext.getInstance().isToolRunning(tool.getId(), "runningFlag")) {
                Field toolfield = tool.getField();
                if (null != field && null != toolfield && STORAGE.equals(toolfield.getId()) && STORAGE.equals(field.getId())) {
                    return true;
                }
            }
            if (!ApplicationContext.getInstance().isToolRunning(tool.getId(), "backFlag")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCurToolRunning(String toolId, List<Tool> allTools) {
        for (Tool tool : allTools) {
            if (!toolId.equals(tool.getId())) continue;
            if (ApplicationContext.getInstance().isToolRunning(tool.getId(), "runningFlag")) {
                return true;
            }
            if (!ApplicationContext.getInstance().isToolRunning(tool.getId(), "backFlag")) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBackToolRunning(List<Tool> allTools) {
        for (Tool tool : allTools) {
            if (!ApplicationContext.getInstance().isToolRunning(tool.getId(), "backFlag")) continue;
            return true;
        }
        return false;
    }
}

