/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.autotest;

import com.huawei.ism.autotest.AutoProcessItem;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AutoProcessConfig {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AutoProcessConfig.class);
    private static AutoProcessConfig instance;
    private String ip = "";
    private String port = "";
    private String userName = "";
    private String userPassword = "";
    private List<String> processList = new ArrayList<String>();
    private String currentProcess;
    private HashMap<String, String> processInput = new HashMap();
    private HashMap<String, List<String>> processSteps = new HashMap();
    private HashMap<String, List<String>> stepCheckItems = new HashMap();
    private HashMap<String, AutoProcessItem> expectResults = new HashMap();

    private AutoProcessConfig() {
    }

    public static AutoProcessConfig getInstance() {
        if (instance == null) {
            instance = new AutoProcessConfig();
            instance.parse();
        }
        return instance;
    }

    private String getConfigFilePath() {
        StringBuilder pathBuffer = new StringBuilder(ApplicationContext.getInstance().getWorkPath());
        pathBuffer.append(File.separator);
        pathBuffer.append("temp");
        pathBuffer.append(File.separator);
        pathBuffer.append("AutoProcessConfig.xml");
        return pathBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        File configFile = new File(FilePathUtils.filterPath(this.getConfigFilePath()));
        if (!configFile.exists()) {
            String errMsg = String.format(Locale.ROOT, "config file: %s doesn't exist. AutoProcess failed!", this.getConfigFilePath());
            LOGGER.error(errMsg);
        }
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(configFile);
            Document doc = XmlUtils.parseDocument(inStream);
            Element root = doc.getDocumentElement();
            this.parseConnection(root);
            this.parseProcess(root);
        }
        catch (Exception e) {
            LOGGER.error("config file parse error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeResource(null, inStream);
        }
    }

    private void parseConnection(Element root) {
        Element connection = XmlUtils.getChild(root, "device");
        this.ip = XmlUtils.getAttribute(connection, "ip");
        this.port = XmlUtils.getAttribute(connection, "port");
        this.userName = XmlUtils.getAttribute(connection, "username");
        this.userPassword = XmlUtils.getAttribute(connection, "password");
        LOGGER.info(String.format(Locale.ROOT, "ip: %s, port: %s, userName: %s", this.ip, this.port, this.userName));
    }

    private void parseProcess(Element root) {
        Collection<Element> processCollection = XmlUtils.getChildren(root, "process");
        for (Element process : processCollection) {
            String processName = XmlUtils.getAttribute(process, "name");
            this.processList.add(processName);
            this.parseInput(process, processName);
            this.parseStep(process, processName);
        }
        LOGGER.info(String.format(Locale.ROOT, "processList: %s", this.processList.toString()));
        LOGGER.info(String.format(Locale.ROOT, "processSteps: %s", this.processSteps.toString()));
        LOGGER.info(String.format(Locale.ROOT, "stepCheckItems: %s", this.stepCheckItems.toString()));
        LOGGER.info(String.format(Locale.ROOT, "expectResults: %s", this.expectResults.toString()));
    }

    private void parseInput(Element process, String processName) {
        Element input = XmlUtils.getChild(process, "processInput");
        this.processInput.put(processName, input.getTextContent());
    }

    private void parseStep(Element process, String processName) {
        Collection<Element> steps = XmlUtils.getChildren(process, "step");
        ArrayList<String> stepIds = new ArrayList<String>();
        for (Element step : steps) {
            String stepId = XmlUtils.getAttribute(step, "id");
            stepIds.add(stepId);
            String checkItemKey = String.format(Locale.ROOT, "%s#%s", processName, stepId);
            this.parseCheckItem(step, checkItemKey);
        }
        this.processSteps.put(processName, stepIds);
    }

    private void parseCheckItem(Element step, String checkItemKey) {
        Collection<Element> checkItems = XmlUtils.getChildren(step, "checkitem");
        ArrayList<String> itemIds = new ArrayList<String>();
        for (Element checkItem : checkItems) {
            AutoProcessItem item = new AutoProcessItem();
            String id = XmlUtils.getAttribute(checkItem, "id");
            String result = XmlUtils.getAttribute(checkItem, "expectResult");
            String errMsg = XmlUtils.getAttribute(checkItem, "expectErrorMessage");
            String suggestion = XmlUtils.getAttribute(checkItem, "expectSuggestion");
            String expectKey = String.format(Locale.ROOT, "%s#%s", checkItemKey, id);
            item.setId(id);
            item.setResult(result);
            item.setErrorMessage(errMsg);
            item.setSuggestion(suggestion);
            itemIds.add(id);
            this.expectResults.put(expectKey, item);
        }
        this.stepCheckItems.put(checkItemKey, itemIds);
    }

    public HashMap<String, List<String>> getProcessSteps() {
        return this.processSteps;
    }

    public void setProcessSteps(HashMap<String, List<String>> processSteps) {
        this.processSteps = processSteps;
    }

    public HashMap<String, List<String>> getStepCheckItems() {
        return this.stepCheckItems;
    }

    public void setStepCheckItems(HashMap<String, List<String>> stepCheckItems) {
        this.stepCheckItems = stepCheckItems;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public List<String> getProcessList() {
        return this.processList;
    }

    public HashMap<String, String> getProcessInput() {
        return this.processInput;
    }

    public String getCurrentProcess() {
        return this.currentProcess;
    }

    public void setCurrentProcess(String currentProcess) {
        this.currentProcess = currentProcess;
    }

    public HashMap<String, AutoProcessItem> getExpectResults() {
        return this.expectResults;
    }

    public void setExpectResults(HashMap<String, AutoProcessItem> expectResults) {
        this.expectResults = expectResults;
    }
}

