/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.entity.alarm;

import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlarmEmailConfig
implements Cloneable {
    private transient List<String> receivers = new ArrayList<String>(0);
    private boolean supportSSL = false;
    private Map<Event.Level, Collection<String>> classficationRecives = new HashMap<Event.Level, Collection<String>>(0);
    private Event.Level alarmLevel;
    private String arrayId;
    private boolean enableState;
    private boolean needSMTPCheck;
    private String pawd;
    private String sender;
    private String smtpServer;
    private String userName;
    private boolean enableSSL;
    private int port;

    public AlarmEmailConfig(String arrayId, Event.Level level, String smtpServer, String sender, Collection<String> receivers) {
        this.arrayId = arrayId;
        this.enableState = false;
        this.alarmLevel = level;
        this.needSMTPCheck = false;
        this.smtpServer = smtpServer;
        this.sender = sender;
        this.userName = "";
        this.pawd = "";
        this.addReceivers(receivers);
    }

    public AlarmEmailConfig(String arrayId, Event.Level level, String smtpServer, String sender, Collection<String> receivers, Map<Event.Level, Collection<String>> receiversMap) {
        this(arrayId, level, smtpServer, sender, receivers);
        if (null != this.classficationRecives) {
            this.classficationRecives = receiversMap;
        }
    }

    public AlarmEmailConfig(String arrayID, boolean enableState, Event.Level level, boolean needCheckSMTP, String smtpServerName, String senderNums, String userName, String pwd, Collection<String> receivers) throws IsmException {
        this.arrayId = arrayID;
        this.enableState = enableState;
        this.alarmLevel = level;
        this.needSMTPCheck = needCheckSMTP;
        this.smtpServer = smtpServerName;
        this.sender = senderNums;
        this.userName = userName;
        this.pawd = pwd;
        this.addReceivers(receivers);
    }

    public synchronized void addReceiver(String receiver) throws IsmException {
        if (receiver != null && !"".equals(receiver)) {
            this.receivers.add(receiver);
        }
    }

    public synchronized void addReceivers(Collection<String> receiversIn) {
        this.receivers.addAll(receiversIn);
    }

    public synchronized void clearReceivers() {
        this.receivers.clear();
    }

    public boolean equals(Object object) {
        AlarmEmailConfig config;
        boolean isEqual = false;
        if (object == this) {
            isEqual = true;
        } else if (object == null) {
            isEqual = false;
        } else if (object instanceof AlarmEmailConfig && this.checkEqual(config = (AlarmEmailConfig)object)) {
            isEqual = true;
        }
        return isEqual;
    }

    private boolean checkEqual(AlarmEmailConfig config) {
        return this.arrayId.equals(config.arrayId) && this.pawd.equals(config.pawd) && this.sender.equals(config.sender) && this.smtpServer.equals(config.smtpServer) && this.userName.equals(config.userName) && this.alarmLevel == config.alarmLevel && this.enableState == config.enableState && this.needSMTPCheck == config.needSMTPCheck && this.receivers.equals(config.receivers) && this.classficationRecives.equals(config.classficationRecives);
    }

    public void setAlarmLevel(Event.Level level) {
        this.alarmLevel = level;
    }

    public Event.Level getAlarmLevel() {
        return this.alarmLevel;
    }

    public String getArrayId() {
        return this.arrayId;
    }

    public void setDeviceID(String deviceID) {
        this.arrayId = deviceID;
    }

    public void setPassword(String password) {
        this.pawd = password;
    }

    public String getPassword() {
        return this.pawd;
    }

    public synchronized Collection<String> getReceivers() {
        ArrayList<String> newReceivers = new ArrayList<String>(0);
        for (String recive : this.receivers) {
            if (null == recive || "".equals(recive.trim())) continue;
            newReceivers.add(recive);
        }
        return newReceivers;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getSender() {
        return this.sender;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public String getUserName() {
        return this.userName;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.arrayId.hashCode();
        hashCode = 37 * hashCode + this.pawd.hashCode();
        hashCode = 37 * hashCode + this.sender.hashCode();
        hashCode = 37 * hashCode + this.smtpServer.hashCode();
        hashCode = 37 * hashCode + this.userName.hashCode();
        hashCode = 37 * hashCode + this.alarmLevel.hashCode();
        hashCode = 37 * hashCode + Boolean.valueOf(this.enableState).hashCode();
        hashCode = 37 * hashCode + Boolean.valueOf(this.needSMTPCheck).hashCode();
        hashCode = 37 * hashCode + this.receivers.hashCode();
        return hashCode;
    }

    public boolean isEnableState() {
        return this.enableState;
    }

    public boolean isNeedSMTPCheck() {
        return this.needSMTPCheck;
    }

    public synchronized boolean removeReceiver(String receiver) {
        boolean removeSuccess = this.receivers.remove(receiver);
        return removeSuccess;
    }

    public void setEnableState(boolean state) {
        this.enableState = state;
    }

    public void setIsNeedSMTPCheck(boolean needSMTPCheckIn) {
        this.needSMTPCheck = needSMTPCheckIn;
    }

    public void setSmtpServer(String server) {
        this.smtpServer = server;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public void setSupportSSL(boolean supportSSL) {
        this.supportSSL = supportSSL;
    }

    public boolean isSupportSSL() {
        return this.supportSSL;
    }

    public void setEnableSSL(boolean enableSSL) {
        this.enableSSL = enableSSL;
    }

    public boolean isEnableSSL() {
        return this.enableSSL;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getDetail() {
        StringBuilder builder = new StringBuilder();
        builder.append(ResourceManager.getString("COMMON.TXT.SEND_LEVEL"));
        builder.append(": ");
        builder.append(this.alarmLevel.toString());
        builder.append(" ");
        builder.append(ResourceManager.getString("ALARM_EMAIL_NOTIFICATION_ALARM_EMAIL_NOTIFICATION_EMAIL_MANAGE"));
        builder.append(": ");
        String receiver = null;
        for (int i = 0; i < this.receivers.size(); ++i) {
            receiver = this.receivers.get(i);
            builder.append(receiver);
            if (i == this.receivers.size() - 1) continue;
            builder.append(',');
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(ResourceManager.getString("COMMON.TXT.SEND_LEVEL"));
        builder.append(": ");
        builder.append(this.alarmLevel.toString());
        builder.append("; ");
        builder.append(ResourceManager.getString("ALARM_EMAIL_NOTIFICATION_ALARM_EMAIL_NOTIFICATION_EMAIL_MANAGE"));
        builder.append(": ");
        String receiver = null;
        for (int i = 0; i < this.receivers.size(); ++i) {
            receiver = this.receivers.get(i);
            builder.append(receiver);
            if (i == this.receivers.size() - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public AlarmEmailConfig clone() throws CloneNotSupportedException {
        AlarmEmailConfig clone = (AlarmEmailConfig)super.clone();
        clone.receivers = new ArrayList<String>(this.receivers);
        clone.classficationRecives = this.classficationRecives;
        return clone;
    }

    public void setClassficationRecives(Event.Level level, Collection<String> reciveNums) {
        if (null != this.classficationRecives.get((Object)level)) {
            this.classficationRecives.remove((Object)level);
        }
        this.classficationRecives.put(level, reciveNums);
    }

    public void setClassficationRecives(Map<Event.Level, Collection<String>> classficationRecives) {
        this.classficationRecives = classficationRecives;
    }

    public Collection<String> getClassficationRecivesByLevel(Event.Level level) {
        Collection<String> reciveNums = this.classficationRecives.get((Object)level);
        if (null == reciveNums) {
            return new ArrayList<String>(0);
        }
        return reciveNums;
    }

    public Map<Event.Level, Collection<String>> getClassficationRecives() {
        return this.classficationRecives;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

