/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.resourcemanager;

import com.huawei.ism.common.resourcemanager.LocalResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public final class ConfigFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileManager.class);
    private static ConfigFileManager instance = null;
    private ClassLoader classLoader = null;

    private ConfigFileManager() {
    }

    public static ConfigFileManager getInstance() {
        if (null == instance) {
            instance = new ConfigFileManager();
        }
        return instance;
    }

    public String extractConfiguation(String confFile, ClassLoader loader) throws IsmException {
        this.classLoader = loader;
        if (!FileUtils.fileSize2GInvalid(new File(confFile))) {
            ToolLoggerFactory.getLogger(this.getClass()).error("extract cnfiguation error.");
            return null;
        }
        return this.extractConfiguation(LocalResourceManager.getInstance().getUserDataDir(), confFile);
    }

    private String extractConfiguation(String toDir, String confFile) {
        String configurationPath = toDir;
        String absPath = configurationPath + File.separator + confFile;
        File file = new File(absPath);
        if (file.exists()) {
            return absPath;
        }
        ArrayList<String> files = new ArrayList<String>(0);
        files.add(confFile);
        this.extract(files, configurationPath);
        return absPath;
    }

    private boolean extract(Collection<String> files, String todir) {
        String distFile = null;
        for (String relativeFileName : files) {
            distFile = todir + File.separator + relativeFileName;
            if (relativeFileName.endsWith(".properties")) {
                this.extractPropertyFile(relativeFileName, distFile);
                continue;
            }
            if (!relativeFileName.endsWith(".xml")) continue;
            this.extractXmlFile(relativeFileName, distFile);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractPropertyFile(String src, String dist) {
        block13: {
            Properties commProps = new Properties();
            InputStream input = null;
            try {
                input = this.classLoader.getResourceAsStream(src);
                commProps.load(input);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IsmException("read property file fail:" + e.getMessage(), (Throwable)e);
            }
            finally {
                this.closeIOStream(input);
            }
            try {
                boolean success = this.createNewFile(dist, true);
                if (!success) break block13;
                Writer out = null;
                try {
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(dist)), Charset.defaultCharset());
                    Enumeration<Object> keys = commProps.keys();
                    Object key = null;
                    Object value = null;
                    while (keys.hasMoreElements()) {
                        key = keys.nextElement();
                        value = commProps.get(key);
                        out.write(key + " = " + value + System.getProperty("line.separator"));
                    }
                }
                finally {
                    if (null != out) {
                        out.close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IsmException("create new property file fail:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void closeIOStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IsmException("close property file fail:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void extractXmlFile(String src, String dist) {
        InputStream file = null;
        try {
            Transformer transformer = XmlUtils.newTransformer();
            boolean success = this.createNewFile(dist, true);
            if (!FileUtils.fileSize2GInvalid(new File(src))) {
                return;
            }
            if (success) {
                file = this.classLoader.getResourceAsStream(src);
                Document doc = XmlUtils.parseDocument(file);
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(dist);
                transformer.transform(source, result);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IsmException("Extract xml file fail:" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IsmException("Extract xml file fail:" + e.getMessage(), (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, file);
        }
    }

    private boolean createNewFile(String fileName, boolean deleteOnExist) throws IOException {
        boolean returnValue = false;
        File file = new File(fileName);
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("mkdirs failed.");
        }
        if (file.exists()) {
            if (deleteOnExist) {
                if (!file.delete()) {
                    throw new IOException("delete file failed.");
                }
                returnValue = file.createNewFile();
            } else {
                returnValue = true;
            }
        } else {
            returnValue = file.createNewFile();
        }
        return returnValue;
    }
}

