/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.exception;

import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.ErrorMessage;
import com.huawei.ism.util.parser.XmlParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ErrorMessageManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorMessageManager.class);
    private static Map<Locale, Map<Long, ErrorMessage>> messagePool = new HashMap<Locale, Map<Long, ErrorMessage>>(0);
    private static ReadWriteLock rwl = new ReentrantReadWriteLock();

    private ErrorMessageManager() {
    }

    private static Map<Long, ErrorMessage> initErrorDefinition(XmlParser domParser) {
        HashMap<Long, ErrorMessage> errorMessageMap = new HashMap<Long, ErrorMessage>(0);
        if (null == domParser) {
            return errorMessageMap;
        }
        Element node = domParser.treeWalkOfOneElementNode("errors");
        if (null == node) {
            throw new NullPointerException();
        }
        Element element = node;
        NodeList nodeList = element.getElementsByTagName("error");
        int length = nodeList.getLength();
        ErrorMessage errorMessage = null;
        Node rowNode = null;
        NamedNodeMap nodeMap = null;
        long messageID = 0L;
        String eventIDStr = null;
        Element errorElement = null;
        String reason = null;
        List<String> suggestions = null;
        for (int i = 0; i < length; ++i) {
            errorMessage = new ErrorMessage();
            rowNode = nodeList.item(i);
            nodeMap = rowNode.getAttributes();
            eventIDStr = nodeMap.getNamedItem("id").getNodeValue();
            if (null == eventIDStr || eventIDStr.length() == 0) continue;
            messageID = Long.decode(eventIDStr);
            errorElement = (Element)rowNode;
            reason = ErrorMessageManager.parseReason(domParser, errorElement);
            suggestions = ErrorMessageManager.parseSuggestion(domParser, errorElement);
            errorMessage.setID(messageID);
            errorMessage.setReason(reason);
            errorMessage.setSuggestions(suggestions);
            errorMessageMap.put(messageID, errorMessage);
        }
        return errorMessageMap;
    }

    private static String parseReason(XmlParser domParser, Element errorElement) {
        Element reasonElement = domParser.treeWalkOfOneElementNode(errorElement, "reason");
        String reason = "";
        if (reasonElement != null) {
            reason = domParser.getAttributeValueOfElementNode(reasonElement, "description");
        }
        return reason;
    }

    private static List<String> parseSuggestion(XmlParser domParser, Element errorElement) {
        ArrayList<String> suggestions = new ArrayList<String>(0);
        Element suggestionsElement = domParser.treeWalkOfOneElementNode(errorElement, "suggestions");
        Collection<Element> suggestionNodes = domParser.getChildren(suggestionsElement, "suggestion");
        Iterator<Element> iterator = suggestionNodes.iterator();
        Element suggestionNode = null;
        String suggestion = null;
        while (iterator.hasNext()) {
            suggestionNode = iterator.next();
            suggestion = domParser.getAttributeValueOfElementNode(suggestionNode, "description");
            suggestions.add(suggestion);
        }
        return suggestions;
    }

    private static Map<Long, ErrorMessage> getCurrentMap() {
        return messagePool.get(ResourceManager.getLocale());
    }

    public static String getErrorMessage(long errorID) {
        return ErrorMessageManager.getErrorReason(errorID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorReason(long errorID) {
        rwl.readLock().lock();
        try {
            ErrorMessage message = ErrorMessageManager.getCurrentMap().get(errorID);
            if (message == null) {
                String string = "--";
                return string;
            }
            String string = message.getReason();
            return string;
        }
        finally {
            rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getErrorSuggestions(long errorID) {
        rwl.readLock().lock();
        try {
            ErrorMessage message = ErrorMessageManager.getCurrentMap().get(errorID);
            if (message == null) {
                ArrayList<String> arrayList = new ArrayList<String>(0);
                return arrayList;
            }
            List<String> list = message.getSuggestions();
            return list;
        }
        finally {
            rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addErrorFile(Locale locale, File definitionFile) {
        rwl.writeLock().lock();
        try {
            XmlParser domParser = XmlParser.getXmlDomParser(definitionFile);
            Map<Long, ErrorMessage> errorMessageMap = ErrorMessageManager.initErrorDefinition(domParser);
            Map<Long, ErrorMessage> cachedMap = messagePool.get(locale);
            if (null == cachedMap) {
                cachedMap = errorMessageMap;
            } else {
                cachedMap.putAll(errorMessageMap);
            }
            messagePool.put(locale, cachedMap);
        }
        finally {
            rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getErrorSuggestions(Locale locale, long errorID) {
        rwl.readLock().lock();
        try {
            ErrorMessage message = messagePool.get(locale).get(errorID);
            if (message == null) {
                ArrayList<String> arrayList = new ArrayList<String>(0);
                return arrayList;
            }
            List<String> list = message.getSuggestions();
            return list;
        }
        finally {
            rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorReason(Locale locale, long errorID) {
        rwl.readLock().lock();
        try {
            ErrorMessage message = messagePool.get(locale).get(errorID);
            if (message == null) {
                String string = "--";
                return string;
            }
            String string = message.getReason();
            return string;
        }
        finally {
            rwl.readLock().unlock();
        }
    }

    static {
        try {
            List<Locale> languages = CustomResourceManager.getInstance().getLanguages();
            String definitionFile = null;
            Map<Long, ErrorMessage> errorMessageMap = null;
            for (Locale locale : languages) {
                definitionFile = "config/framework/configuration/error_" + locale.getLanguage() + ".xml";
                XmlParser domParser = XmlParser.getXmlDomParser(definitionFile);
                errorMessageMap = ErrorMessageManager.initErrorDefinition(domParser);
                messagePool.put(locale, errorMessageMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("initEventDefinition error", (Throwable)e);
        }
    }
}

