/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tool.base.utils.StringUtils;
import java.util.Arrays;
import java.util.Optional;

public class DiskScanMO {
    private MO mo;

    public DiskScanMO(MO mo) {
        this.mo = mo;
    }

    public MOType getType() {
        return MOType.getType(Integer.parseInt(this.mo.getProperty(TLV.DISK_SCAN_TASK.TYPE).toString()));
    }

    public String getID() {
        return this.mo.getStrProperty(TLV.DISK_SCAN_TASK.ID);
    }

    public String getName() {
        return this.mo.getStrProperty(TLV.DISK_SCAN_TASK.NAME);
    }

    public String getParentID() {
        return this.mo.getStrProperty(TLV.DISK_SCAN_TASK.PARENTID);
    }

    public String getLocation() {
        return this.mo.getStrProperty(TLV.DISK_SCAN_TASK.LOCATION);
    }

    public EnumDefine.RUNNING_STATUS_E getRunningStatus() {
        Object runningStatus = this.mo.getProperty(TLV.DISK_SCAN_TASK.SCANSTATUS);
        Object runningResult = this.mo.getProperty(TLV.DISK_SCAN_TASK.SCANRESULT);
        return this.getRunningStatusFromStatus(runningStatus, runningResult);
    }

    private EnumDefine.RUNNING_STATUS_E getRunningStatusFromStatus(Object runningStatus, Object runningResult) {
        return Optional.ofNullable(runningStatus).map(status -> CliStatus.getEnumByStatus(status.toString()).getRunningStatus()).orElse(Optional.ofNullable(runningResult).map(string -> CliResult.getEnumByResult(string.toString()).getRunningStatus()).orElse(EnumDefine.RUNNING_STATUS_E.valueOf(Integer.parseInt(null == runningStatus || !StringUtils.isDigit(runningStatus.toString()) ? "-1" : runningStatus.toString()))));
    }

    public int getProgress() {
        return this.mo.getIntProperty(TLV.DISK_SCAN_TASK.PROGRESS);
    }

    public String getRemainTime() {
        return this.mo.getStrProperty(TLV.DISK_SCAN_TASK.REMAINTIME);
    }

    public String getStatus() {
        return this.mo.getStrProperty(TLV.DISK_SCAN_TASK.SCANSTATUS);
    }

    public String getResult() {
        return this.mo.getStrProperty(TLV.DISK_SCAN_TASK.SCANRESULT);
    }

    public EnumDefine.DISK_SCAN_ERROR_E getDiskScanError() {
        String errorCode = this.mo.getStrProperty(TLV.DISK_SCAN_TASK.SCANERRORCODE);
        if (StringUtils.isDigit(errorCode)) {
            return EnumDefine.DISK_SCAN_ERROR_E.valueOf(Integer.valueOf(errorCode));
        }
        Object scanError = this.mo.getProperty(TLV.DISK_SCAN_TASK.SCANERROR);
        return EnumDefine.DISK_SCAN_ERROR_E.valueOf(Integer.parseInt(null == scanError ? "0" : scanError.toString()));
    }

    public String toString() {
        return this.mo.toString();
    }

    private static enum CliResult {
        FAIL("fail", EnumDefine.RUNNING_STATUS_E.FAILED),
        OK("ok", EnumDefine.RUNNING_STATUS_E.SUCCESS),
        SCANNING("scanning", EnumDefine.RUNNING_STATUS_E.RUNNING),
        NOTSUPPORT("notSupport", EnumDefine.RUNNING_STATUS_E.INACTIVATED),
        UNKNOWN("unknown", EnumDefine.RUNNING_STATUS_E.UNKNOWN);

        String result;
        EnumDefine.RUNNING_STATUS_E runningStatus;

        private CliResult(String result, EnumDefine.RUNNING_STATUS_E runningStatus) {
            this.result = result;
            this.runningStatus = runningStatus;
        }

        public String getResult() {
            return this.result;
        }

        public EnumDefine.RUNNING_STATUS_E getRunningStatus() {
            return this.runningStatus;
        }

        static CliResult getEnumByResult(String result) {
            return Arrays.stream(CliResult.values()).filter(obj -> obj.getResult().equals(result)).findAny().orElse(UNKNOWN);
        }
    }

    private static enum CliStatus {
        SCANNING("scanning", EnumDefine.RUNNING_STATUS_E.RUNNING),
        SCANNED("scanned", null),
        STOPPING("stopping", EnumDefine.RUNNING_STATUS_E.RUNNING),
        STOPPED("stopped", EnumDefine.RUNNING_STATUS_E.CANCELLED),
        NOTSUPPORT("notSupport", EnumDefine.RUNNING_STATUS_E.INACTIVATED),
        UNKNOWN("unknown", EnumDefine.RUNNING_STATUS_E.UNKNOWN);

        String status;
        EnumDefine.RUNNING_STATUS_E runningStatus;

        private CliStatus(String status, EnumDefine.RUNNING_STATUS_E runningStatus) {
            this.status = status;
            this.runningStatus = runningStatus;
        }

        public String getStatus() {
            return this.status;
        }

        public EnumDefine.RUNNING_STATUS_E getRunningStatus() {
            return this.runningStatus;
        }

        static CliStatus getEnumByStatus(String status) {
            return Arrays.stream(CliStatus.values()).filter(obj -> obj.getStatus().equals(status)).findAny().orElse(UNKNOWN);
        }
    }
}

