/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareInfoAdapter;
import com.huawei.ism.tool.framework.pubservice.hardware.IEnclosureInfo;
import java.util.Map;

public class EnclosureMO
extends HardwareInfoAdapter
implements IEnclosureInfo {
    private final MO mo;

    public EnclosureMO(MO mo) {
        this.mo = mo;
    }

    public EnclosureMO(Map<String, String> dataDict) {
        this.mo = new MO(new UUID(dataDict.get("deviceId"), Integer.parseInt(dataDict.get("moType")), dataDict.get("id")));
        this.mo.setOtherInfo(dataDict);
    }

    public UUID getUUID() {
        return this.mo.getUUID();
    }

    @Override
    public MOType getType() {
        return MOType.getType(Integer.parseInt(this.mo.getProperty(TLV.ENCLOSURE.TYPE).toString()));
    }

    public void setType(MOType type) {
        this.mo.setProperty(TLV.ENCLOSURE.TYPE, type.getValue());
    }

    @Override
    public String getID() {
        return this.mo.getStrProperty(TLV.ENCLOSURE.ID);
    }

    public void setID(String id) {
        this.mo.setProperty(TLV.ENCLOSURE.ID, id);
    }

    public String getMOName() {
        if (this.isControllerEncolsure()) {
            return ResourceManager.getStringWithParams("physical.treenode.name.controllerenclosure", this.getName());
        }
        if (this.isDiskEncolsure()) {
            return ResourceManager.getStringWithParams("physical.treenode.name.diskenclosure", this.getName());
        }
        return "";
    }

    public Param getIDParam() {
        if (this.getID() == null) {
            return null;
        }
        return new Param(TLV.ENCLOSURE.ID.getParamIndex(), TLV.ENCLOSURE.ID.getParamType(), this.getID());
    }

    @Override
    public String getName() {
        return this.mo.getStrProperty(TLV.ENCLOSURE.NAME);
    }

    public void setName(String name) {
        this.mo.setProperty(TLV.ENCLOSURE.NAME, name);
    }

    public Param getNameParam() {
        if (this.getName() == null) {
            return null;
        }
        return new Param(TLV.ENCLOSURE.NAME.getParamIndex(), TLV.ENCLOSURE.NAME.getParamType(), this.getName());
    }

    @Override
    public int getParentType() {
        return Integer.parseInt(this.mo.getProperty(TLV.ENCLOSURE.PARENTTYPE).toString());
    }

    public void setParentType(MOType parentType) {
        this.mo.setProperty(TLV.ENCLOSURE.PARENTTYPE, parentType.getValue());
    }

    @Override
    public String getParentID() {
        return this.mo.getStrProperty(TLV.ENCLOSURE.PARENTID);
    }

    public void setParentID(String parentID) {
        this.mo.setProperty(TLV.ENCLOSURE.PARENTID, parentID);
    }

    @Override
    public String getLocation() {
        return this.mo.getStrProperty(TLV.ENCLOSURE.LOCATION);
    }

    public void setLocation(String location) {
        this.mo.setProperty(TLV.ENCLOSURE.LOCATION, location);
    }

    public Param getLocationParam() {
        if (this.getLocation() == null) {
            return null;
        }
        return new Param(TLV.ENCLOSURE.LOCATION.getParamIndex(), TLV.ENCLOSURE.LOCATION.getParamType(), this.getLocation());
    }

    @Override
    public int getHealthStatus() {
        return Integer.parseInt(this.mo.getProperty(TLV.ENCLOSURE.HEALTHSTATUS).toString());
    }

    public void setHealthStatus(EnumDefine.HEALTH_STATUS_E healthStatus) {
        this.mo.setProperty(TLV.ENCLOSURE.HEALTHSTATUS, healthStatus.getValue());
    }

    public EnumDefine.RUNNING_STATUS_E getRunningStatus() {
        return EnumDefine.RUNNING_STATUS_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.ENCLOSURE.RUNNINGSTATUS).toString()));
    }

    public void setRunningStatus(EnumDefine.RUNNING_STATUS_E runningStatus) {
        this.mo.setProperty(TLV.ENCLOSURE.RUNNINGSTATUS, runningStatus.getValue());
    }

    public long getCount() {
        return this.mo.getLongProperty(TLV.ENCLOSURE.COUNT);
    }

    @Override
    public Object getModel() {
        Object mod = this.mo.getProperty(TLV.ENCLOSURE.MODEL);
        return null == mod ? null : EnumDefine.ENCLOSURE_MODEL_E.valueOf(Integer.parseInt(mod.toString()));
    }

    public void setModel(EnumDefine.ENCLOSURE_MODEL_E modelType) {
        this.mo.setProperty(TLV.ENCLOSURE.MODEL, modelType.getValue());
    }

    public EnumDefine.ENCLOSURE_TYPE_E getLogicType() {
        return EnumDefine.ENCLOSURE_TYPE_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.ENCLOSURE.LOGICTYPE).toString()));
    }

    public void setLogicType(EnumDefine.ENCLOSURE_TYPE_E logicType) {
        this.mo.setProperty(TLV.ENCLOSURE.LOGICTYPE, logicType.getValue());
    }

    public boolean isControllerEncolsure() {
        EnumDefine.ENCLOSURE_TYPE_E type = this.getLogicType();
        return EnumDefine.ENCLOSURE_TYPE_E.CTRL.equals((Object)type);
    }

    public boolean isDiskEncolsure() {
        EnumDefine.ENCLOSURE_TYPE_E type = this.getLogicType();
        return EnumDefine.ENCLOSURE_TYPE_E.EXP.equals((Object)type);
    }

    public long getTemperature() {
        return this.mo.getLongProperty(TLV.ENCLOSURE.TEMPERATURE);
    }

    public String getSerialNum() {
        return this.mo.getStrProperty(TLV.ENCLOSURE.SERIALNUM);
    }

    public void setSerialNum(String serialNum) {
        this.mo.setProperty(TLV.ENCLOSURE.SERIALNUM, serialNum);
    }

    public Param getSerialNumParam() {
        if (this.getSerialNum() == null) {
            return null;
        }
        return new Param(TLV.ENCLOSURE.SERIALNUM.getParamIndex(), TLV.ENCLOSURE.SERIALNUM.getParamType(), this.getSerialNum());
    }

    public String getMacAddress() {
        return this.mo.getStrProperty(TLV.ENCLOSURE.MACADDRESS);
    }

    public Param getMacAddressParam() {
        if (this.getMacAddress() == null) {
            return null;
        }
        return new Param(TLV.ENCLOSURE.MACADDRESS.getParamIndex(), TLV.ENCLOSURE.MACADDRESS.getParamType(), this.getMacAddress());
    }

    public long getHeight() {
        return this.mo.getLongProperty(TLV.ENCLOSURE.HEIGHT);
    }

    public Long getExpanderDepth() {
        return this.mo.getLongProperty(TLV.ENCLOSURE.EXPANDERDEPTH);
    }

    public void setExpanderDepth(Long expanderDepth) {
        this.mo.setProperty(TLV.ENCLOSURE.EXPANDERDEPTH, new UnsignedInt32(expanderDepth));
    }

    public String getExpanderPort() {
        return this.mo.getStrProperty(TLV.ENCLOSURE.EXPANDERPORT);
    }

    public void setExpanderPort(String expanderPort) {
        this.mo.setProperty(TLV.ENCLOSURE.EXPANDERPORT, expanderPort);
    }

    public Param getExpanderPortParam() {
        if (this.getExpanderPort() == null) {
            return null;
        }
        return new Param(TLV.ENCLOSURE.EXPANDERPORT.getParamIndex(), TLV.ENCLOSURE.EXPANDERPORT.getParamType(), this.getExpanderPort());
    }

    public MO getMO() {
        return this.mo;
    }

    public void setSwitchStatus(EnumDefine.SWITCH_E switchStatus) {
        this.mo.setProperty(TLV.ENCLOSURE.SWITCHSTATUS, (Object)switchStatus);
    }

    public EnumDefine.SWITCH_E getSwitchStatus() {
        if (this.mo.getProperty(TLV.ENCLOSURE.SWITCHSTATUS) == null) {
            return null;
        }
        return EnumDefine.SWITCH_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.ENCLOSURE.SWITCHSTATUS).toString()));
    }

    @Override
    public String getLogicTypeName() {
        EnumDefine.ENCLOSURE_TYPE_E type = this.getLogicType();
        return type.name();
    }

    @Override
    public boolean isNormal() {
        return true;
    }

    @Override
    public int getHeightU() {
        Object model = this.getModel();
        if (null == model) {
            return 0;
        }
        return ((EnumDefine.ENCLOSURE_MODEL_E)((Object)model)).getHeight();
    }

    @Override
    public int getStartU() {
        return 0;
    }
}

