/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.layout;

import com.huawei.ism.ui.layout.KeyValueLayoutRow;
import com.huawei.ism.ui.layout.LayoutRow;
import com.huawei.ism.ui.layout.LayoutUtils;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.UCD;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class LayoutGroup {
    private Border border = null;
    private List<LayoutRow> rows = new ArrayList<LayoutRow>(0);

    public void addLayoutRow(LayoutRow row) {
        this.rows.add(row);
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public Border getBorder() {
        return this.border;
    }

    public JComponent doLayout() {
        JPanel box = UCD.createBoxLayoutPane(1);
        LayoutRow row = null;
        for (int i = 0; i < this.rows.size(); ++i) {
            row = this.rows.get(i);
            box.add(row.doLayout());
            if (i >= this.rows.size() - 1) continue;
            box.add(Box.createVerticalStrut(8));
        }
        return box;
    }

    public int getKeyMinWidth() {
        int minWidth = 0;
        KeyValueLayoutRow keyValueRow = null;
        for (LayoutRow row : this.rows) {
            int width;
            if (!(row instanceof KeyValueLayoutRow) || minWidth >= (width = (keyValueRow = (KeyValueLayoutRow)row).getKeyComponentsMinWidth())) continue;
            minWidth = width;
        }
        return minWidth;
    }

    public int getValueComponentsMaxWidth() {
        int width = 0;
        for (LayoutRow row : this.rows) {
            KeyValueLayoutRow keyValueRow;
            int compWidth;
            if (!(row instanceof KeyValueLayoutRow) || (compWidth = (keyValueRow = (KeyValueLayoutRow)row).getValueComponentsMaxWidth()) <= width) continue;
            width = compWidth;
        }
        return width;
    }

    public void setKeyWidth(int width) {
        KeyValueLayoutRow keyValueRow = null;
        for (LayoutRow row : this.rows) {
            if (!(row instanceof KeyValueLayoutRow)) continue;
            keyValueRow = (KeyValueLayoutRow)row;
            keyValueRow.setKeyWidth(width);
        }
    }

    public JComponent addRows2Component(boolean autoResize, List<Pair<JComponent, JComponent>> pairs) {
        KeyValueLayoutRow row = null;
        JComponent component = null;
        JComponent keyComp = null;
        for (Pair<JComponent, JComponent> pair : pairs) {
            row = new KeyValueLayoutRow();
            keyComp = pair.getKey();
            component = pair.getValue();
            row.addKeyComponent(keyComp, true);
            row.addValueComponent(autoResize, component);
            this.addLayoutRow(row);
        }
        return LayoutUtils.doLayout(this);
    }
}

