/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.event;

import com.huawei.ism.common.bean.Event;

public abstract class EventFilter {
    public static EventFilter createDeviceFilter(final String deviceID) {
        return new EventFilter(){

            @Override
            public boolean include(Event event) {
                return event.getIdentifier().getDeviceID().equals(deviceID);
            }
        };
    }

    public static EventFilter createLevelFilter(final Event.Level level) {
        return new EventFilter(){

            @Override
            public boolean include(Event event) {
                return event.getLevel().equals((Object)level);
            }
        };
    }

    public static EventFilter createFaultFilter() {
        return new EventFilter(){

            @Override
            public boolean include(Event event) {
                return event.getLevel().isFault() && !event.isRecovered();
            }
        };
    }

    public static EventFilter andFilter(final EventFilter ... filters) {
        return new EventFilter(){

            @Override
            public boolean include(Event event) {
                for (EventFilter filter : filters) {
                    if (filter.include(event)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static EventFilter orFilter(final EventFilter ... filters) {
        return new EventFilter(){

            @Override
            public boolean include(Event event) {
                for (EventFilter filter : filters) {
                    if (!filter.include(event)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public abstract boolean include(Event var1);
}

