/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.event;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.KeywordFilterField;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class FaultTabLayout
extends JPanel {
    private static final String CLEAR_BUTTON_TEXT = ResourceManager.getString("ABSTRACT_ALARM_PANEL_CLEAR");
    private static final String SAVE_BUTTON_TEXT = ResourceManager.getString("ABSTRACT_ALARM_PANEL_SAVE");
    private static final char SAVE_BUTTON_MNEMONIC = 'A';
    private static final char CLEAR_BUTTON_MNEMONIC = 'C';
    private static final char REFRESH_BUTTON_MNEMONIC = 'R';
    private static final String REFRESH_BUTTON_TEXT = ResourceManager.getString("ABSTRACT_ALARM_PANEL_REFRESH");
    private static final long serialVersionUID = 1L;
    private static final Dimension BUTTON_DIMENSION = new Dimension(85, 21);
    private static final int BUTTON_SHORT_GAP = 4;
    private static final int BUTTON_LONG_GAP = 10;
    private static final Dimension COMBOMBOX_DIMENSION = new Dimension(200, 21);
    private static final Dimension ALARM_PANEL_DIMENSION = new Dimension(820, 520);
    private static final int BOX_GAP_TWELVE = 12;
    private IsmTable ismTable;
    private JButton clearFilterButton;
    private JButton saveButton;
    private JButton clearButton;
    private JButton refreshButton;
    private JComboBox deviceComboBox;
    private JComboBox sourceComboBox;
    private JComboBox levelComboBox;
    private KeywordFilterField keywordFilter;

    public FaultTabLayout(IsmTable table) {
        this.ismTable = table;
        this.init();
    }

    private void init() {
        this.setOpaque(false);
        Box topFilter = this.initTopFilterPane();
        JComponent centerPane = this.createTablePane();
        centerPane.setOpaque(false);
        Box buttonPane = this.initButtonPane();
        buttonPane.setBorder(new EmptyBorder(0, 8, 0, 8));
        buttonPane.setOpaque(false);
        Box contentBox = Box.createVerticalBox();
        contentBox.add(topFilter);
        contentBox.add(Box.createVerticalStrut(12));
        contentBox.add(centerPane);
        contentBox.add(Box.createVerticalStrut(12));
        contentBox.add(buttonPane);
        contentBox.setBorder(new EmptyBorder(12, 8, 9, 8));
        this.setLayout(new BorderLayout());
        this.add((Component)contentBox, "Center");
        this.setPreferredSize(ALARM_PANEL_DIMENSION);
        this.setMaximumSize(ALARM_PANEL_DIMENSION);
        this.setMinimumSize(ALARM_PANEL_DIMENSION);
    }

    private Box initButtonPane() {
        this.saveButton = new JButton(SAVE_BUTTON_TEXT);
        this.saveButton.setEnabled(false);
        this.saveButton.setPreferredSize(new Dimension(100, 21));
        this.saveButton.setMnemonic('A');
        this.clearButton = new JButton(CLEAR_BUTTON_TEXT);
        this.clearButton.setEnabled(false);
        this.clearButton.setPreferredSize(BUTTON_DIMENSION);
        this.clearButton.setMnemonic('C');
        this.refreshButton = new JButton(REFRESH_BUTTON_TEXT);
        this.refreshButton.setEnabled(false);
        this.refreshButton.setPreferredSize(BUTTON_DIMENSION);
        this.refreshButton.setMnemonic('R');
        return this.createBtnBox();
    }

    protected Box createBtnBox() {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalStrut(4));
        box.add(this.saveButton);
        box.add(Box.createHorizontalStrut(4));
        box.add(this.clearButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.refreshButton);
        return box;
    }

    private JComponent createTablePane() {
        JPanel tablePanel = new JPanel();
        tablePanel.setOpaque(false);
        tablePanel.setLayout(new BorderLayout());
        this.ismTable.setSelectionMode(2);
        tablePanel.add((Component)new TableScrollPane(this.ismTable, false, true), "Center");
        return tablePanel;
    }

    private Box initTopFilterPane() {
        Box filterBox = Box.createHorizontalBox();
        JLabel label = new JLabel(ResourceManager.getString("EVENT_MANAGER_FILTER_LABEL"));
        this.sourceComboBox = new JComboBox();
        this.sourceComboBox.setPreferredSize(COMBOMBOX_DIMENSION);
        this.sourceComboBox.setMaximumSize(COMBOMBOX_DIMENSION);
        this.sourceComboBox.setMinimumSize(COMBOMBOX_DIMENSION);
        this.deviceComboBox = new JComboBox();
        this.deviceComboBox.setPreferredSize(COMBOMBOX_DIMENSION);
        this.deviceComboBox.setMaximumSize(COMBOMBOX_DIMENSION);
        this.deviceComboBox.setMinimumSize(COMBOMBOX_DIMENSION);
        this.levelComboBox = new JComboBox();
        Dimension levelDim = new Dimension(95, 21);
        this.levelComboBox.setPreferredSize(levelDim);
        this.levelComboBox.setMinimumSize(levelDim);
        this.levelComboBox.setMaximumSize(levelDim);
        this.clearFilterButton = UCD.createButton(ResourceManager.getString("EVENT_MANAGER_CLEAR_FILTER"), 'F');
        filterBox.add(label);
        filterBox.add(Box.createHorizontalStrut(8));
        filterBox.add(this.deviceComboBox);
        filterBox.add(Box.createHorizontalStrut(12));
        filterBox.add(this.sourceComboBox);
        filterBox.add(Box.createHorizontalStrut(12));
        filterBox.add(this.levelComboBox);
        filterBox.add(Box.createHorizontalStrut(12));
        this.keywordFilter = new KeywordFilterField(this.ismTable);
        filterBox.add(this.keywordFilter);
        filterBox.add(Box.createHorizontalStrut(12));
        filterBox.add(this.clearFilterButton);
        filterBox.add(Box.createGlue());
        this.clearFilterButton.setEnabled(false);
        return filterBox;
    }

    public IsmTable getIsmTable() {
        return this.ismTable;
    }

    public void setIsmTable(IsmTable ismTable) {
        this.ismTable = ismTable;
    }

    public JButton getClearFilterButton() {
        return this.clearFilterButton;
    }

    public void setClearFilterButton(JButton clearFilterButton) {
        this.clearFilterButton = clearFilterButton;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public void setSaveButton(JButton saveButton) {
        this.saveButton = saveButton;
    }

    public JButton getClearButton() {
        return this.clearButton;
    }

    public void setClearButton(JButton clearButton) {
        this.clearButton = clearButton;
    }

    public JButton getRefreshButton() {
        return this.refreshButton;
    }

    public void setRefreshButton(JButton refreshButton) {
        this.refreshButton = refreshButton;
    }

    public JComboBox getDeviceComboBox() {
        return this.deviceComboBox;
    }

    public void setDeviceComboBox(JComboBox deviceComboBox) {
        this.deviceComboBox = deviceComboBox;
    }

    public JComboBox getSourceComboBox() {
        return this.sourceComboBox;
    }

    public void setSourceComboBox(JComboBox sourceComboBox) {
        this.sourceComboBox = sourceComboBox;
    }

    public JComboBox getLevelComboBox() {
        return this.levelComboBox;
    }

    public void setLevelComboBox(JComboBox levelComboBox) {
        this.levelComboBox = levelComboBox;
    }

    public KeywordFilterField getKeywordFilter() {
        return this.keywordFilter;
    }

    public void setKeywordFilter(KeywordFilterField keywordFilter) {
        this.keywordFilter = keywordFilter;
    }
}

