/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.perfhis.proxy;

import com.huawei.ism.common.bean.PerfStatObjectType;
import com.huawei.ism.common.resourcemanager.LocalResourceManager;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.ui.module.perfhis.Tools;
import com.huawei.ism.ui.module.perfhis.pojo.PerfStatHisThreshold;
import com.huawei.ism.ui.module.perfhis.util.GetResultTask;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfStatHisThresholdProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerfStatHisThresholdProxy.class);
    private static final String THRESHOLDS_FILE_NAME = "config/framework/configuration/perfStat/perfStat.dat";
    private static final String SEPARATOR = ",";
    private static final String COMMENT_SIGN = "#";

    public static List<PerfStatHisThreshold> getAll() {
        LinkedList<PerfStatHisThreshold> perfStatHisThresholds = new LinkedList<PerfStatHisThreshold>();
        List<String> lines = PerfStatHisThresholdProxy.readFileByLines();
        String[] items = null;
        PerfStatHisThreshold perfStatHisThreshold = null;
        for (String line : lines) {
            if ("".equals(line) || line.startsWith(COMMENT_SIGN)) continue;
            items = line.split(SEPARATOR);
            perfStatHisThreshold = new PerfStatHisThreshold();
            perfStatHisThreshold.setId(Integer.parseInt(items[0].trim()));
            perfStatHisThreshold.setObjectType(PerfStatObjectType.ObjectTypeEnum.valueOf(items[1].trim()));
            perfStatHisThreshold.setDataType(PerfStatObjectType.DataTypeEnum.valueOf(items[2].trim()));
            perfStatHisThreshold.setRecommendValue(Tools.convertStringToInteger(items[3].trim()));
            perfStatHisThreshold.setValue(Tools.convertStringToInteger(items[4].trim()));
            perfStatHisThreshold.setUnit(items[5].trim());
            perfStatHisThresholds.add(perfStatHisThreshold);
        }
        return perfStatHisThresholds;
    }

    public static boolean updateAll(List<PerfStatHisThreshold> perfStatHisThresholds) {
        List<String> lines = PerfStatHisThresholdProxy.readFileByLines();
        int id = 0;
        String line = null;
        String newLine = null;
        for (PerfStatHisThreshold perfStatHisThreshold : perfStatHisThresholds) {
            id = perfStatHisThreshold.getId();
            for (int index = 0; index < lines.size(); ++index) {
                line = lines.get(index);
                if (!PerfStatHisThresholdProxy.isSpecifiedLine(line, id)) continue;
                newLine = PerfStatHisThresholdProxy.convertPerfStatHisThresholdToLine(perfStatHisThreshold);
                lines.remove(index);
                lines.add(index, newLine);
            }
        }
        return PerfStatHisThresholdProxy.saveFileByLines(lines);
    }

    public static Integer findByObjectTypeAndDataType(PerfStatObjectType.ObjectTypeEnum objectType, PerfStatObjectType.DataTypeEnum dataType) {
        if (objectType == null || dataType == null) {
            return null;
        }
        List<PerfStatHisThreshold> perfStatHisThresholds = PerfStatHisThresholdProxy.getAll();
        for (PerfStatHisThreshold perfStatHisThreshold : perfStatHisThresholds) {
            if (perfStatHisThreshold == null || !objectType.equals((Object)perfStatHisThreshold.getObjectType()) || !dataType.equals((Object)perfStatHisThreshold.getDataType())) continue;
            return perfStatHisThreshold.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readFileByLines() {
        LinkedList<String> lines = new LinkedList<String>();
        Reader fr = null;
        BufferedReader br = null;
        try {
            String absoluteFile = LocalResourceManager.getInstance().getUserDataDir() + File.separator + THRESHOLDS_FILE_NAME;
            File file = new File(absoluteFile);
            fr = new InputStreamReader((InputStream)new FileInputStream(file.getCanonicalFile()), Charset.defaultCharset());
            br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                lines.add(line.trim());
            }
            LinkedList<String> linkedList = lines;
            return linkedList;
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(PerfStatHisThresholdProxy.class).error("read file failsed", (Throwable)e);
            LinkedList<String> linkedList = new LinkedList<String>();
            return linkedList;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(PerfStatHisThresholdProxy.class).error("read file failed", (Throwable)e);
            LinkedList<String> linkedList = new LinkedList<String>();
            return linkedList;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    ToolLoggerFactory.getLogger(PerfStatHisThresholdProxy.class).error("close FileReader failed", (Throwable)e);
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    ToolLoggerFactory.getLogger(PerfStatHisThresholdProxy.class).error("close BufferedReader failed", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean saveFileByLines(List<String> lines) {
        Writer fw = null;
        BufferedWriter bw = null;
        try {
            String absoluteFile = LocalResourceManager.getInstance().getUserDataDir() + File.separator + THRESHOLDS_FILE_NAME;
            File file = new File(absoluteFile);
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file.getCanonicalFile()), Charset.defaultCharset());
            bw = new BufferedWriter(fw);
            for (String line : lines) {
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
            fw.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    ToolLoggerFactory.getLogger(PerfStatHisThresholdProxy.class).error("save FileByLines error.", (Throwable)e);
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    ToolLoggerFactory.getLogger(PerfStatHisThresholdProxy.class).error("save FileByLines error.", (Throwable)e);
                }
            }
        }
    }

    private static boolean isSpecifiedLine(String line, int id) {
        if (line == null) {
            return false;
        }
        try {
            String[] items = line.split(SEPARATOR);
            return Integer.parseInt(items[0]) == id;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String convertPerfStatHisThresholdToLine(PerfStatHisThreshold perfStatHisThreshold) {
        if (perfStatHisThreshold == null) {
            return "";
        }
        String line = "";
        line = line + perfStatHisThreshold.getId() + SEPARATOR;
        line = line + PerfStatHisThresholdProxy.noNullString(perfStatHisThreshold.getObjectType().name()) + SEPARATOR;
        line = line + PerfStatHisThresholdProxy.noNullString(perfStatHisThreshold.getDataType().name()) + SEPARATOR;
        line = line + Tools.convertIntegerToString(perfStatHisThreshold.getRecommendValue()) + SEPARATOR;
        line = line + Tools.convertIntegerToString(perfStatHisThreshold.getValue()) + SEPARATOR;
        line = line + PerfStatHisThresholdProxy.noNullString(perfStatHisThreshold.getUnit());
        return line;
    }

    private static String noNullString(String string) {
        return string == null ? "" : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        String absoluteFile = LocalResourceManager.getInstance().getUserDataDir() + File.separator + THRESHOLDS_FILE_NAME;
        File file = new File(absoluteFile);
        if (!file.exists()) {
            byte[] buffer = new byte[512];
            InputStream is = null;
            BufferedInputStream bis = null;
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            try {
                is = FileUtils.getStreamWithObj(PerfStatHisThresholdProxy.class, THRESHOLDS_FILE_NAME);
                bis = new BufferedInputStream(is);
                if (!file.getParentFile().mkdirs()) {
                    LOGGER.info("create new threshold dir fail.");
                    throw new IOException();
                }
                if (!file.createNewFile()) {
                    LOGGER.info("create new threshold file fail.");
                    throw new IOException();
                }
                fos = new FileOutputStream(file.getCanonicalFile());
                bos = new BufferedOutputStream(fos);
                int length = 0;
                while ((length = bis.read(buffer)) > 0) {
                    bos.write(buffer, 0, length);
                    bos.flush();
                }
            }
            catch (RuntimeException e) {
                LOGGER.error("copy threshold file from jar  ee to client error:" + e.getMessage(), (Throwable)e);
                StreamUtils.closeStream(fos, is);
                StreamUtils.closeStream(bos, bis);
            }
            catch (Exception e2) {
                LOGGER.error("copy threshold file from jar to client error:" + e2.getMessage(), (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        StreamUtils.closeStream(fos, is);
                        StreamUtils.closeStream(bos, bis);
                        throw throwable;
                    }
                }
                StreamUtils.closeStream(fos, is);
                StreamUtils.closeStream(bos, bis);
            }
            StreamUtils.closeStream(fos, is);
            StreamUtils.closeStream(bos, bis);
        }
    }

    public static final class UpdateAllTask
    extends GetResultTask {
        private final List<PerfStatHisThreshold> perfStatHisThresholds;

        public UpdateAllTask(List<PerfStatHisThreshold> perfStatHisThresholds) {
            this.perfStatHisThresholds = perfStatHisThresholds;
        }

        @Override
        public Object call() {
            try {
                this.setExecuteResult(PerfStatHisThresholdProxy.updateAll(this.perfStatHisThresholds));
                this.setException(null);
                this.setExecuteSucess(true);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                this.setExecuteResult(null);
                this.setException(e);
                this.setExecuteSucess(false);
            }
            return this.getExecuteResult();
        }
    }
}

