/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.task;

import com.huawei.ism.ui.module.task.BackgroundTask;

public abstract class TaskFilter {
    public static TaskFilter createDeviceFilter(final String deviceID) {
        return new TaskFilter(){

            @Override
            public boolean include(BackgroundTask task) {
                if (null == task || null == task.getDviceId()) {
                    return false;
                }
                return task.getDviceId().equals(deviceID);
            }
        };
    }

    public static TaskFilter createTaskSNFilter(final String taskSN) {
        return new TaskFilter(){

            @Override
            public boolean include(BackgroundTask task) {
                if (null == task || null == task.getTaskSN()) {
                    return false;
                }
                return task.getTaskSN().equals(taskSN);
            }
        };
    }

    public static TaskFilter createAllDeviceFilter() {
        return new TaskFilter(){

            @Override
            public boolean include(BackgroundTask task) {
                return null != task;
            }
        };
    }

    public static TaskFilter andFilter(final TaskFilter ... filters) {
        return new TaskFilter(){

            @Override
            public boolean include(BackgroundTask task) {
                for (TaskFilter filter : filters) {
                    if (filter.include(task)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static TaskFilter orFilter(final TaskFilter ... filters) {
        return new TaskFilter(){

            @Override
            public boolean include(BackgroundTask task) {
                for (TaskFilter filter : filters) {
                    if (!filter.include(task)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public abstract boolean include(BackgroundTask var1);
}

