/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.calendar;

import com.huawei.ism.util.CommonUtil;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.PlainDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateSpinnerEditor2
extends JSpinner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateSpinnerEditor2.class);
    private static final long serialVersionUID = 1L;
    private static final String DATA_REGEX = "(([0-1]\\d)|2[0-3]|\\d{0,1}):([0-5]\\d|\\d{0,1}):([0-5]\\d|\\d{0,1})";
    private static final String HHMM_DATA_REGEX = "(([0-1]\\d)|2[0-3]|\\d{0,1}):([0-5]\\d|\\d{0,1})";
    private Pattern pattern;
    private JSpinner.DateEditor dateeditor;
    private SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
    private String dateFormat;

    public DateSpinnerEditor2() {
        this.pattern = Pattern.compile(DATA_REGEX);
        this.dateFormat = "HH:mm:ss";
        this.init();
    }

    public DateSpinnerEditor2(SpinnerModel model) {
        this.spinnerDateModel = CommonUtil.convertObject(model, SpinnerDateModel.class);
        this.pattern = Pattern.compile(HHMM_DATA_REGEX);
        this.dateFormat = "HH:mm";
        this.init();
    }

    private void init() {
        this.setModel(this.spinnerDateModel);
        this.dateeditor = new JSpinner.DateEditor((JSpinner)this, this.dateFormat);
        JFormattedTextField textField = this.dateeditor.getTextField();
        textField.setHorizontalAlignment(4);
        this.setTextFieldDocument(textField);
        textField.getActionMap().put(textField.getInputMap().get(KeyStroke.getKeyStroke("ctrl A")), new MyCustAction());
        textField.setHighlighter(new BasicTextUI.BasicHighlighter(){

            @Override
            public void changeHighlight(Object tag, int p0, int p1) throws BadLocationException {
                int minDot = p0 / 3 * 3;
                int maxDot = minDot + 2;
                if (p1 < minDot || p1 > maxDot) {
                    return;
                }
                super.changeHighlight(tag, p0, p1);
            }

            @Override
            public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
                int minDot = p0 / 3 * 3;
                int maxDot = minDot + 2;
                if (p1 < minDot || p1 > maxDot) {
                    return null;
                }
                return super.addHighlight(p0, p1, highlightPainter);
            }
        });
        textField.getCaret().addChangeListener(new MyChangeListner(textField));
        this.setEditor(this.dateeditor);
    }

    private void setTextFieldDocument(JFormattedTextField textField) {
        textField.setDocument(new PlainDocument(){
            private static final long serialVersionUID = -5949402722724014375L;

            @Override
            protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
                String proposedInsert;
                try {
                    proposedInsert = this.getText(0, this.getLength());
                }
                catch (BadLocationException e) {
                    LOGGER.error("bad location exception:", (Throwable)e);
                    return;
                }
                String reg = "(([0-1]\\d)|2[0-3]|\\d{0,1}):[6-9][0-9]";
                String str = "([3-9][0-9]):([0-5]\\d|\\d{0,1})";
                String str1 = "2[4-9]:([0-5]\\d|\\d{0,1})";
                Pattern pattern1 = Pattern.compile(reg);
                Pattern pattern2 = Pattern.compile(str);
                if (pattern1.matcher(proposedInsert).matches() || pattern2.matcher(proposedInsert).matches() || Pattern.compile(str1).matcher(proposedInsert).matches()) {
                    return;
                }
                Matcher matcher = DateSpinnerEditor2.this.pattern.matcher(proposedInsert);
                if (!matcher.matches()) {
                    try {
                        this.remove(chng.getOffset(), chng.getLength());
                    }
                    catch (BadLocationException e) {
                        LOGGER.error("bad location exception:", (Throwable)e);
                    }
                    return;
                }
                super.insertUpdate(chng, attr);
            }
        });
    }

    public JSpinner.DateEditor getDateEditor() {
        return this.dateeditor;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    private static final class MyCustAction
    extends AbstractAction {
        private static final long serialVersionUID = -8630510133047564407L;

        private MyCustAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static final class MyChangeListner
    implements ChangeListener {
        private final JFormattedTextField textField;

        private MyChangeListner(JFormattedTextField textField) {
            this.textField = textField;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int mark = this.textField.getCaret().getMark();
            int minDot = mark / 3 * 3;
            int maxDot = minDot + 2;
            int dot = this.textField.getCaret().getDot();
            if (dot < minDot) {
                this.textField.getCaret().moveDot(minDot);
                return;
            }
            if (dot > maxDot) {
                this.textField.getCaret().moveDot(maxDot);
                return;
            }
        }
    }
}

