/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class BatchInfoDialog
extends JDialog {
    private static final long serialVersionUID = 235979318247568808L;
    private JButton okBtn = UCD.createButton(ResourceManager.getString("COMMON.TXT.CONFIRM"), 'O');
    private String[] infoHeader = new String[]{ResourceManager.getString("batch.info.line.1"), ResourceManager.getString("batch.info.line.2")};
    private DefaultTableModel infoTableModel = new DefaultTableModel(this.infoHeader, new int[0]);
    private IsmTable infoTable = new IsmTable(this.infoTableModel);
    private Map<String, String> messages;
    private String desc;

    public BatchInfoDialog(Window parent, String desc, Map<String, String> messages) {
        super(parent);
        this.messages = messages;
        this.desc = desc;
        this.initUI();
        this.initData();
        this.addListeners();
    }

    private void addListeners() {
        this.okBtn.requestFocus();
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchInfoDialog.this.dispose();
            }
        });
    }

    private void initData() {
        for (Map.Entry<String, String> message : this.messages.entrySet()) {
            DefaultTableRow row = new DefaultTableRow(this.infoHeader.length, message.getKey());
            row.setValueAt(0, message.getKey());
            row.setValueAt(1, message.getValue());
            this.infoTableModel.addRow(row);
        }
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.setTitle(ResourceManager.getString("INFORMATION_DIALOG_TITLE"));
        JTextArea textdesc = this.createTextArea();
        JComponent mainCom = UCD.buildVerticalBox(null, UCD.buildHBoxLeft(textdesc), this.createMainPanel());
        mainCom.setBorder(UCD.createEmptyBorder(12));
        this.setLayout(new BorderLayout());
        this.add(mainCom);
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        this.toFront();
        this.setCompName();
        SwingUtil.putScreenCenter(this);
    }

    private JTextArea createTextArea() {
        JTextArea infoArea = new JTextArea();
        infoArea.setLineWrap(true);
        infoArea.setWrapStyleWord(true);
        infoArea.setFocusable(false);
        infoArea.setEditable(false);
        infoArea.setOpaque(false);
        infoArea.setBackground(UIManager.getColor("Panel.background"));
        infoArea.setText(this.desc);
        return infoArea;
    }

    private JComponent createMainPanel() {
        JScrollPane scrollPane = new JScrollPane(this.infoTable);
        scrollPane.setPreferredSize(new Dimension(350, 250));
        return UCD.buildVerticalBox(null, scrollPane, UCD.buildHBoxCentert(this.okBtn));
    }

    private void setCompName() {
        this.okBtn.setName("_Button_okBtn");
        this.infoTable.setName("_Table_infoTable");
    }
}

