/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.armor.ArmorRootPaneUI;
import com.huawei.ism.util.SwingUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class HeadlessDialog
extends JDialog {
    private static final long serialVersionUID = -3481019795504831146L;

    public HeadlessDialog() {
        this.setUndecorated(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
    }

    public HeadlessDialog(Window parent) {
        super(parent);
    }

    @Override
    protected void dialogInit() {
        this.setUndecorated(true);
        super.dialogInit();
        if (JDialog.isDefaultLookAndFeelDecorated()) {
            JRootPane rootPane = this.getRootPane();
            boolean supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations();
            if (supportsWindowDecorations) {
                this.setUndecorated(true);
                if (rootPane.getUI() instanceof ArmorRootPaneUI) {
                    rootPane.setWindowDecorationStyle(0);
                } else {
                    rootPane.setWindowDecorationStyle(2);
                }
            }
        }
    }

    protected Box createButtonPane(Component btnContentPane) {
        AreaSeparator separator = new AreaSeparator();
        Box southBox = Box.createVerticalBox();
        southBox.add(separator);
        southBox.add(btnContentPane);
        JPanel panel = new JPanel();
        panel.add(Box.createVerticalStrut(4));
        panel.setPreferredSize(new Dimension(panel.getPreferredSize().width, 4));
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            panel.setBackground(new Color(0xD9D9D9));
        }
        southBox.add(panel);
        return southBox;
    }

    @Override
    public void dispose() {
        Window window = this.getOwner();
        super.dispose();
        SwingUtil.postEvent(window);
    }

    @Override
    public void setLocationRelativeTo(Component component) {
        if (component != null && !component.isShowing()) {
            this.setLocationRelativeTo(component.getParent());
        } else {
            super.setLocationRelativeTo(component);
        }
    }

    private static final class AreaSeparator
    extends JSeparator {
        private static final long serialVersionUID = -6149201948604054011L;

        private AreaSeparator() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(new Color(0xCECECE));
            graphics.drawLine(0, 0, this.getWidth(), 0);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(0, 1, this.getWidth(), 1);
        }
    }
}

