/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.tuple.Pair;

public class MultiErrorDialog
extends IsmDialog {
    private static final long serialVersionUID = -2587908427263722274L;
    private DefaultTableModel errorTableModel = null;
    private JButton confirmButton;
    private JButton ignoreButton;
    private int dialogValue = -1;
    private boolean showIgnoreButton = false;
    private int doubleBtnScrollWidth = 500;

    public MultiErrorDialog(Window parent, String errMsg, String[] titles) {
        this(parent, ResourceManager.getString("ERROR_DIALOG_TITLE"), errMsg, titles, "error.png");
    }

    public MultiErrorDialog(Window parent, String errMsg, String[] titles, Pair<String, String> pair) {
        this(parent, ResourceManager.getString("ERROR_DIALOG_TITLE"), errMsg, (Pair<String[], String>)Pair.of((Object)titles, (Object)"error.png"), pair);
    }

    public MultiErrorDialog(Window parent, String errMsg, String[] titles, boolean showIgnoreButton) {
        super(parent);
        this.showIgnoreButton = showIgnoreButton;
        this.commonInit(parent, ResourceManager.getString("WARNING_DIALOG_TITLE"), errMsg, titles, "comfirmdialog_warn.png");
    }

    public MultiErrorDialog(Window parent, String errMsg, String[] titles, boolean showIgnoreButton, DefaultTableModel tableModel) {
        super(parent);
        this.showIgnoreButton = showIgnoreButton;
        this.errorTableModel = tableModel;
        this.commonInit(parent, ResourceManager.getString("WARNING_DIALOG_TITLE"), errMsg, titles, "comfirmdialog_warn.png");
    }

    public MultiErrorDialog(Window parent, String dlgTitle, String infoMsg, String[] titles, String img) {
        super(parent);
        this.commonInit(parent, dlgTitle, infoMsg, titles, img);
    }

    public MultiErrorDialog(Window parent, String dlgTitle, String infoMsg, Pair<String[], String> imgPair, Pair<String, String> pair) {
        super(parent);
        this.showIgnoreButton = true;
        this.doubleBtnScrollWidth = 350;
        this.commonInitWithBtnInfo(parent, dlgTitle, infoMsg, imgPair, pair);
    }

    public MultiErrorDialog(Window parent, boolean showIgnoreButton, int doubleBtnScrollWidth) {
        super(parent);
        this.showIgnoreButton = showIgnoreButton;
        this.doubleBtnScrollWidth = doubleBtnScrollWidth;
    }

    private void commonInit(Window parent, String dlgTitle, String infoMsg, String[] titles, String img) {
        this.commonInitWithBtnInfo(parent, dlgTitle, infoMsg, (Pair<String[], String>)Pair.of((Object)titles, (Object)img), (Pair<String, String>)Pair.of((Object)ResourceManager.getString("CLOSE"), (Object)ResourceManager.getString("IGNORE")));
    }

    public void commonInitWithBtnInfo(Window parent, String dlgTitle, String infoMsg, Pair<String[], String> imgPair, Pair<String, String> pair) {
        this.setTitle(dlgTitle);
        this.doLayoutPane(infoMsg, (String[])imgPair.getLeft(), (String)imgPair.getRight(), pair);
        this.addEventHandler();
        this.toFront();
        this.setCompName();
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setResizable(true);
        SwingUtil.setCloseWhenEscKeyPressed(this);
        this.setIconImage(ResourceManager.DEFAULT_ICON.getImage());
        this.getRootPane().setDefaultButton(this.confirmButton);
        this.confirmButton.requestFocus();
        this.pack();
        SwingUtil.putParentCenter(this, parent);
    }

    private void addEventHandler() {
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiErrorDialog.this.dispose();
            }
        });
        if (this.ignoreButton != null) {
            this.ignoreButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultiErrorDialog.this.ignoreButtonAction(e);
                }
            });
        }
    }

    private void doLayoutPane(String errMsg, String[] titles, String img, Pair<String, String> pair) {
        IsmTextArea displayPrompt = new IsmTextArea();
        displayPrompt.setText(errMsg);
        JLabel imgLabel = new JLabel();
        imgLabel.setIcon(ResourceManager.getImage(img));
        if (this.errorTableModel == null) {
            this.errorTableModel = new DefaultTableModel(titles, new int[0]);
        }
        IsmTable errTable = new IsmTable(this.errorTableModel);
        TableScrollPane scrollPane = new TableScrollPane(errTable);
        if (this.showIgnoreButton) {
            scrollPane.setPreferredSize(new Dimension(this.doubleBtnScrollWidth, 250));
        } else {
            scrollPane.setPreferredSize(new Dimension(350, 250));
        }
        JComponent imgBox = UCD.buildVerticalBox(null, imgLabel, Box.createVerticalGlue());
        JComponent descBox = UCD.buildVerticalBox(null, displayPrompt, Box.createVerticalGlue());
        JComponent topBox = UCD.buildHorizotalBox(null, imgBox, descBox);
        JPanel contentPane = new JPanel(new BorderLayout(10, 10));
        contentPane.add((Component)topBox, "North");
        contentPane.add((Component)scrollPane, "Center");
        contentPane.setBorder(new EmptyBorder(8, 8, 0, 8));
        this.getDialogContentPane().add(contentPane);
        Dimension size = new Dimension(80, 21);
        this.confirmButton = UCD.createButton((String)pair.getLeft(), 'L');
        this.confirmButton.setPreferredSize(size);
        if (this.showIgnoreButton) {
            this.ignoreButton = UCD.createButton((String)pair.getRight(), 'I');
            this.ignoreButton.setPreferredSize(size);
            this.getSouthBox().add(this.ignoreButton);
            this.getSouthBox().add(UCD.buildVerticalBox(null, UCD.buildHBoxRight(this.ignoreButton, this.confirmButton)));
        } else {
            this.getSouthBox().add(this.confirmButton);
        }
    }

    public DefaultTableModel getTableModel() {
        return this.errorTableModel;
    }

    private void setCompName() {
        this.confirmButton.setName("_Button_confirmButton");
    }

    private void ignoreButtonAction(ActionEvent event) {
        this.dialogValue = 0;
        this.dispose();
    }

    public void setErrorTableModel(DefaultTableModel errorTableModel) {
        this.errorTableModel = errorTableModel;
    }

    public int getDialogValue() {
        return this.dialogValue;
    }
}

