/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class PromptDialog
extends IsmDialog {
    public static final int YES = 0;
    public static final int ALL_YES = 1;
    public static final int NO = 2;
    public static final int CANCEL = 3;
    private static final long serialVersionUID = 4806505129744203662L;
    private JLabel imageLabel = null;
    private IsmTextArea displayPrompt = null;
    private int clickedButtonIndex = 0;
    private transient List<JButton> buttons = new ArrayList<JButton>(0);
    private List<Pair<String, Character>> buttonTexts = new ArrayList<Pair<String, Character>>(0);
    private int closeButtonIndex = 0;

    public PromptDialog(Window parent, List<Pair<String, Character>> buttonTexts) {
        super(parent, ResourceManager.getString("WARNING_DIALOG_TITLE"), new IsmDialog.ECommonButton[0]);
        this.buttonTexts.addAll(buttonTexts);
        this.initComponent();
        this.doUILayout();
        this.setModal(true);
        this.setDefaultCloseOperation(2);
    }

    public static int showDownMultiFilePromptDialog(Window parent, String message) {
        ArrayList<Pair<String, Character>> buttonTexts = new ArrayList<Pair<String, Character>>(0);
        buttonTexts.add(new Pair<String, Character>(ResourceManager.getString("YES"), Character.valueOf('Y')));
        buttonTexts.add(new Pair<String, Character>(ResourceManager.getString("ALL_YES"), Character.valueOf('A')));
        buttonTexts.add(new Pair<String, Character>(ResourceManager.getString("NO"), Character.valueOf('N')));
        buttonTexts.add(new Pair<String, Character>(ResourceManager.getString("COMMON.TXT.CANCEL"), Character.valueOf('C')));
        PromptDialog promptDialog = new PromptDialog(parent, buttonTexts);
        promptDialog.setDefaultButton(3);
        promptDialog.setCloseButtonIndex(3);
        promptDialog.setDisplayPrompt(message);
        promptDialog.pack();
        SwingUtil.putParentCenter(promptDialog, parent);
        promptDialog.setVisible(true);
        return promptDialog.getClickButtonIndex();
    }

    public void setDefaultButton(int index) {
        if (index >= 0 && index < this.buttons.size()) {
            JButton button = this.buttons.get(index);
            button.requestFocus();
        }
    }

    public int getClickButtonIndex() {
        return this.clickedButtonIndex;
    }

    @Override
    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.clickedButtonIndex = this.closeButtonIndex;
            this.dispose();
        }
    }

    private void doUILayout() {
        this.getDialogContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.getDialogContentPane().add((Component)this.imageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 9, 0, 0);
        this.getDialogContentPane().add((Component)this.displayPrompt, gridBagConstraints);
        this.getDialogContentPane().setBorder(new EmptyBorder(18, 9, 18, 9));
    }

    private void initComponent() {
        this.imageLabel = new JLabel();
        this.imageLabel.setName("ISMV1R2_framework_WarningDialog_imageLabel");
        ImageIcon imageIcon = ResourceManager.getImage("comfirmdialog_warn.png");
        this.imageLabel.setIcon(imageIcon);
        this.displayPrompt = new IsmTextArea();
        this.displayPrompt.setEditable(false);
        this.displayPrompt.setColumns(26);
        this.displayPrompt.setName("ISMV1R2_framework_WarningDialog_tipLabel");
        this.getSouthBox().removeAll();
        JButton button = null;
        for (Pair<String, Character> buttonText : this.buttonTexts) {
            button = UCD.createButton(buttonText.getKey(), buttonText.getValue().charValue());
            button.addActionListener(this.getActionListener(this.buttonTexts.indexOf(buttonText)));
            this.getSouthBox().add(Box.createHorizontalGlue());
            this.getSouthBox().add(button);
            this.getSouthBox().add(Box.createHorizontalStrut(12));
            this.buttons.add(button);
        }
    }

    private ActionListener getActionListener(final int buttonIndex) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PromptDialog.this.clickedButtonIndex = buttonIndex;
                PromptDialog.this.dispose();
            }
        };
    }

    public void setDisplayPrompt(String displayPromptText) {
        this.displayPrompt.setText(displayPromptText);
    }

    public void setCloseButtonIndex(int closeButtonIndex) {
        this.closeButtonIndex = closeButtonIndex;
    }

    private void readObject(ObjectInputStream ois) {
    }
}

