/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.control.ToolBarButton;
import com.huawei.ism.ui.swing.plaf.IsmBorders;
import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPopupMenuUI;
import com.huawei.ism.ui.swing.plaf.armor.ArmorLookAndFeel;
import com.huawei.ism.ui.swing.plaf.unify.UnifyLookAndFeel;
import com.huawei.ism.util.CommonUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.VolatileImage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IsmPlafUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsmPlafUtils.class);
    private static Locale locale = null;
    private static Robot robot = null;
    private static Kernel kernel = null;
    private static final int MATRIX = 3;

    public static OEMVender getOEMVender() {
        String vender = System.getProperty("VENDER");
        if (null == vender || vender.trim().length() <= 0) {
            vender = "Huawei";
        }
        return OEMVender.valueOf(vender);
    }

    public static LAFStyle getLAFStyle() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof ArmorLookAndFeel) {
            return LAFStyle.armor;
        }
        if (laf instanceof UnifyLookAndFeel) {
            return LAFStyle.unify;
        }
        return LAFStyle.blue;
    }

    public static boolean isArmorStyle() {
        return LAFStyle.armor == IsmPlafUtils.getLAFStyle();
    }

    public static boolean isUnifyStyle() {
        return LAFStyle.unify == IsmPlafUtils.getLAFStyle();
    }

    public static boolean isBlueStyle() {
        return LAFStyle.blue == IsmPlafUtils.getLAFStyle();
    }

    public static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    public static boolean isChineseLocal() {
        return IsmPlafUtils.getLocale().getLanguage().equalsIgnoreCase("zh");
    }

    public static void setLocale(Locale local) {
        locale = local;
    }

    public static Locale getLocale() {
        return locale;
    }

    public static int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("", (Throwable)nfe);
            }
        }
        return defaultValue;
    }

    public static Color mixAlpha(Color col, int alpha) {
        return new Color(col.getRed(), col.getGreen(), col.getBlue(), alpha);
    }

    public static PopupFactory getShadowPopupFactory() {
        return new ShadowPopupFactory();
    }

    public static BufferedImage captureScreen(Rectangle rect, int transpareny) {
        BufferedImage img = null;
        try {
            img = robot.createScreenCapture(rect);
        }
        catch (Throwable ex) {
            int w = rect.width;
            int h = rect.height;
            img = new BufferedImage(w, h, 2);
            Graphics g = img.getGraphics();
            g.setColor(IsmPlafUtils.mixAlpha(Color.WHITE, transpareny));
            g.fillRect(0, 0, w, h);
            g.dispose();
        }
        return img;
    }

    public static BufferedImage blurImage(BufferedImage source, int level) {
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage bluredScreen = new BufferedImage(width, height, 2);
        BufferedImage des = source.getSubimage(0, 0, width, height);
        BufferedImage src = source.getSubimage(0, 0, width, height);
        ConvolveOp cop = new ConvolveOp(kernel, 1, null);
        for (int i = 0; i < level; ++i) {
            des = cop.filter(src, des);
        }
        Graphics g = bluredScreen.getGraphics();
        g.drawImage(des, 0, 0, null);
        return bluredScreen;
    }

    public static void fillSelectionBG(Component c, Graphics graphics, int xx, int yy, int ww, int hh, boolean reverse) {
        graphics.setColor(UIManager.getColor("IsmTheme.selectionBGGradientBG"));
        graphics.fillRect(xx, yy, ww, hh);
    }

    public static void fillSelectionCover(Component c, Graphics graphics, int xx, int yy, int ww, int hh, boolean reverse) {
        Color start = UIManager.getColor("IsmTheme.selectionBGGradientStart");
        Color end = UIManager.getColor("IsmTheme.selectionBGGradientEnd");
        if (reverse) {
            start = IsmPlafUtils.modifyBrightness(end, 80);
            end = IsmPlafUtils.modifyBrightness(start, 130);
            start = IsmPlafUtils.modifySaturation(start, 120);
            end = IsmPlafUtils.modifySaturation(end, 80);
        }
        GradientPaint grad = new GradientPaint(xx, yy, start, xx, yy + hh, end);
        Graphics2D g2D = CommonUtil.convertObject(graphics, Graphics2D.class);
        g2D.setPaint(grad);
        g2D.fillRect(xx, yy, ww, hh);
    }

    public static Color modifyAlpha(Color color, int ratio) {
        int aa = color.getAlpha() * ratio / 100;
        if (aa > 255) {
            aa = 255;
        }
        return IsmPlafUtils.mixAlpha(color, aa);
    }

    public static Color modifySaturation(Color color, int ratio) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = color.getAlpha();
        float[] hsb = new float[3];
        Color.RGBtoHSB(red, green, blue, hsb);
        hsb[1] = hsb[1] * (float)ratio / 100.0f;
        if (hsb[1] > 1.0f) {
            hsb[1] = 1.0f;
        }
        Color modifiedColor = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return IsmPlafUtils.mixAlpha(modifiedColor, alpha);
    }

    public static Color modifyBrightness(Color color, int ratio) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = color.getAlpha();
        float[] hsb = new float[3];
        Color.RGBtoHSB(red, green, blue, hsb);
        hsb[2] = hsb[2] * (float)ratio / 100.0f;
        if (hsb[2] > 1.0f) {
            hsb[2] = 1.0f;
        }
        Color modifiedColor = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return IsmPlafUtils.mixAlpha(modifiedColor, alpha);
    }

    public static void drawButtonBorder(IsmButtonStyle style, IsmButtonStyle.ButtonState state, Graphics graphics, Rectangle area, boolean round) {
        Color innerBorderColorLU;
        if (state == IsmButtonStyle.ButtonState.NONE) {
            return;
        }
        Color oldColor = graphics.getColor();
        Color edgeColor = style.getBorderColor(state);
        graphics.setColor(edgeColor);
        graphics.fillRect((int)area.getX() + 1 + 1, (int)area.getY(), area.width - 2 - 2, 1);
        graphics.fillRect((int)area.getX(), (int)area.getY() + 1 + 1, 1, area.height - 2 - 2);
        graphics.fillRect((int)area.getX() + 1 + 1, (int)area.getY() + area.height - 1, area.width - 2 - 2, 1);
        graphics.fillRect((int)area.getX() + area.width - 1, (int)area.getY() + 1 + 1, 1, area.height - 2 - 2);
        if (state == IsmButtonStyle.ButtonState.DEFAULT) {
            Color innerBorderColorRD = innerBorderColorLU = UIManager.getColor("Button.defaultOutterBorderColor");
            IsmPlafUtils.drawButtonInnerBorder(graphics, innerBorderColorLU, innerBorderColorRD, (int)area.getX(), (int)area.getY(), area.width, area.height);
            graphics.setColor(UIManager.getColor("Button.defaultInnerBorderColor"));
            graphics.drawRect((int)area.getX() + 2, (int)area.getY() + 1 + 1, area.width - 4 - 1, area.height - 4 - 1);
        } else {
            innerBorderColorLU = style.getInnerBorderColorLU(state);
            Color innerBorderColorRD = style.getInnerBorderColorRD(state);
            IsmPlafUtils.drawButtonInnerBorder(graphics, innerBorderColorLU, innerBorderColorRD, (int)area.getX(), (int)area.getY(), area.width, area.height);
        }
        Color cornerColor = style.getBorderCornerColor(state);
        graphics.setColor(cornerColor);
        IsmPlafUtils.drawBorderStyle(graphics, (int)area.getX(), (int)area.getY(), area.width, area.height, round);
        graphics.setColor(oldColor);
    }

    public static void setFrameMaxBounds(Frame frame) {
        GraphicsConfiguration gc;
        if (frame != null && null != (gc = frame.getGraphicsConfiguration())) {
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            Rectangle screenBounds = gc.getBounds();
            screenBounds.setLocation(screenInsets.left, screenInsets.top);
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
            frame.setMaximizedBounds(screenBounds);
        }
    }

    public static void drawArmorButtonBorder(IsmButtonStyle style, IsmButtonStyle.ButtonState state, Graphics graphics, Rectangle area, boolean round) {
        if (state == IsmButtonStyle.ButtonState.NONE) {
            return;
        }
        Color edgeColor = style.getBorderColor(state);
        Color cornerColor = style.getBorderCornerColor(state);
        if (state == IsmButtonStyle.ButtonState.DEFAULT) {
            Color borderColor;
            edgeColor = cornerColor = (borderColor = UIManager.getColor("Button.defaultOutterBorderColor"));
        }
        IsmPlafUtils.drawBorderStyle(graphics, edgeColor, cornerColor, area, round);
    }

    public static void drawBorderStyle(Graphics graphics, Color edgeColor, Color cornerColor, Rectangle area, boolean round) {
        Color oldColor = graphics.getColor();
        graphics.setColor(edgeColor);
        graphics.fillRect((int)area.getX() + 2, (int)area.getY(), area.width - 4, 1);
        graphics.fillRect((int)area.getX(), (int)area.getY() + 2, 1, area.height - 4);
        graphics.fillRect((int)area.getX() + 2, (int)area.getY() + area.height - 1, area.width - 4, 1);
        graphics.fillRect((int)area.getX() + area.width - 1, (int)area.getY() + 2, 1, area.height - 4);
        graphics.setColor(cornerColor);
        IsmPlafUtils.drawBorderStyle(graphics, (int)area.getX(), (int)area.getY(), area.width, area.height, round);
        graphics.setColor(oldColor);
    }

    private static void drawBorderStyle(Graphics graphics, int xx, int yy, int ww, int hh, boolean round) {
        Color oldColor = graphics.getColor();
        if (round) {
            graphics.setColor(IsmPlafUtils.modifyAlpha(oldColor, 70));
            graphics.fillRect(xx, yy + 1, 2, 1);
            graphics.fillRect(xx + 1, yy, 1, 2);
            graphics.fillRect(xx, yy + hh - 2, 2, 1);
            graphics.fillRect(xx + 1, yy + hh - 2, 1, 2);
            graphics.fillRect(xx + ww - 2, yy + hh - 2, 2, 1);
            graphics.fillRect(xx + ww - 2, yy + hh - 2, 1, 2);
            graphics.fillRect(xx + ww - 2, yy + 1, 2, 1);
            graphics.fillRect(xx + ww - 2, yy, 1, 2);
        } else {
            graphics.fillRect(xx, yy, 2, 1);
            graphics.fillRect(xx, yy, 1, 2);
            graphics.fillRect(xx, yy + hh - 2 + 1, 2, 1);
            graphics.fillRect(xx, yy + hh - 2, 1, 2);
            graphics.fillRect(xx + ww - 2, yy + hh - 2 + 1, 2, 1);
            graphics.fillRect(xx + ww - 2 + 1, yy + hh - 2, 1, 2);
            graphics.fillRect(xx + ww - 2, yy, 2, 1);
            graphics.fillRect(xx + ww - 2 + 1, yy, 1, 2);
        }
        graphics.setColor(oldColor);
    }

    public static void drawButtonInnerBorder(Graphics g, Color colorLU, Color colorRD, int x, int y, int w, int h) {
        Color oldColor = g.getColor();
        g.setColor(colorLU);
        g.fillRect(x + 1, y + 1, w - 2, 1);
        g.fillRect(x + 1, y + 1, 1, h - 2);
        g.setColor(colorRD);
        g.fillRect(x + 1, y + h - 3 + 1, w - 2, 1);
        g.fillRect(x + w - 3 + 1, y + 1, 1, h - 2);
        g.setColor(oldColor);
    }

    public static boolean isButtonOnToolBar(AbstractButton button) {
        if (button instanceof ToolBarButton) {
            return true;
        }
        return button.getParent() instanceof JToolBar;
    }

    public static IsmButtonStyle.ButtonState getButtonState(AbstractButton button) {
        ButtonModel model = button.getModel();
        IsmButtonStyle.ButtonState state = IsmButtonStyle.ButtonState.NONE;
        if (!model.isEnabled()) {
            if (!IsmPlafUtils.isButtonOnToolBar(button)) {
                state = IsmButtonStyle.ButtonState.DISABLED;
            }
            return state;
        }
        if (model.isPressed()) {
            state = IsmButtonStyle.ButtonState.PRESSED;
        } else if (model.isRollover()) {
            state = IsmButtonStyle.ButtonState.ROLLOVER;
        } else if (IsmPlafUtils.isButtonOnToolBar(button)) {
            if (model.isSelected()) {
                state = IsmButtonStyle.ButtonState.SELECTED;
            }
        } else {
            state = IsmButtonStyle.ButtonState.NORMAL;
            if (button instanceof JButton && ((JButton)button).isDefaultButton()) {
                state = IsmButtonStyle.ButtonState.DEFAULT;
            }
        }
        return state;
    }

    public static IsmButtonStyle.ButtonState getRolloverButtonState(AbstractButton button) {
        ButtonModel buttonModel = button.getModel();
        IsmButtonStyle.ButtonState state = IsmButtonStyle.ButtonState.NONE;
        if (buttonModel.isEnabled()) {
            if (buttonModel.isPressed()) {
                state = IsmButtonStyle.ButtonState.PRESSED;
            } else if (buttonModel.isRollover()) {
                state = IsmButtonStyle.ButtonState.ROLLOVER;
            } else if (button.hasFocus()) {
                state = IsmButtonStyle.ButtonState.ROLLOVER;
            }
        }
        return state;
    }

    public static void paintFocus(Graphics g, Rectangle area, int r1, int r2, Color color) {
        IsmPlafUtils.paintFocus(g, area, r1, r2, 2.0f, color);
    }

    public static void paintFocus(Graphics graphics, Rectangle area, int r1, int r2, float grosor, Color color) {
        Graphics2D g2d = CommonUtil.convertObject(graphics, Graphics2D.class);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke oldStroke = g2d.getStroke();
        g2d.setColor(color);
        g2d.setStroke(new BasicStroke(grosor));
        if (r1 == 0 && r2 == 0) {
            graphics.drawRect((int)area.getX(), (int)area.getY(), area.width, area.height);
        } else {
            graphics.drawRoundRect((int)area.getX(), (int)area.getY(), area.width - 1, area.height - 1, r1, r2);
        }
        g2d.setStroke(oldStroke);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    public static void fillTexture(Component component, Graphics2D g2, ImageIcon img, Rectangle area) {
        BufferedImage buff = IsmPlafUtils.createBufferedImage(img, component);
        Rectangle anchor = new Rectangle((int)area.getX(), (int)area.getY(), img.getIconWidth(), img.getIconHeight());
        TexturePaint paint = new TexturePaint(buff, anchor);
        g2.setPaint(paint);
        g2.fillRect((int)area.getX(), (int)area.getY(), area.width, area.height);
    }

    public static BufferedImage createBufferedImage(ImageIcon img, Component c) {
        BufferedImage buff = new BufferedImage(img.getIconWidth(), img.getIconHeight(), 2);
        Graphics2D gfx = buff.createGraphics();
        gfx.drawImage(img.getImage(), 0, 0, null);
        gfx.dispose();
        return buff;
    }

    public static boolean drawDualGradient(Component component, Graphics graphics, String key1, String key2, Rectangle area, boolean vertical) {
        boolean ret = true;
        if (!vertical) {
            ret &= IsmPlafUtils.drawGradient(component, graphics, key1, new Rectangle((int)area.getX(), (int)area.getY(), area.width / 2, area.height), vertical);
            ret &= IsmPlafUtils.drawGradient(component, graphics, key2, new Rectangle((int)area.getX() + area.width / 2, (int)area.getY(), area.width / 2, area.height), vertical);
        } else {
            ret &= IsmPlafUtils.drawGradient(component, graphics, key1, new Rectangle((int)area.getX(), (int)area.getY(), area.width, area.height / 2), vertical);
            ret &= IsmPlafUtils.drawGradient(component, graphics, key2, new Rectangle((int)area.getX(), (int)area.getY() + area.height / 2, area.width, area.height / 2), vertical);
        }
        return ret;
    }

    public static boolean drawDualGradient(Component component, Graphics graphics, List<?> gradient1, List<?> gradient2, Rectangle area, boolean vertical) {
        boolean ret = true;
        if (!vertical) {
            ret &= IsmPlafUtils.drawGradient(component, graphics, gradient1, new Rectangle((int)area.getX(), (int)area.getY(), area.width / 2, area.height), vertical);
            ret &= IsmPlafUtils.drawGradient(component, graphics, gradient2, new Rectangle((int)area.getX() + area.width / 2, (int)area.getY(), area.width / 2, area.height), vertical);
        } else {
            ret &= IsmPlafUtils.drawGradient(component, graphics, gradient1, new Rectangle((int)area.getX(), (int)area.getY(), area.width, area.height / 2), vertical);
            ret &= IsmPlafUtils.drawGradient(component, graphics, gradient2, new Rectangle((int)area.getX(), (int)area.getY() + area.height / 2, area.width, area.height / 2), vertical);
        }
        return ret;
    }

    public static boolean drawGradient(Component component, Graphics graphics, String key, Rectangle area, boolean vertical) {
        Object gradientObj = UIManager.get(key);
        List gradient = null;
        if (null != gradientObj && gradientObj instanceof List) {
            gradient = (List)gradientObj;
        }
        return IsmPlafUtils.drawGradient(component, graphics, gradient, area, vertical);
    }

    public static boolean drawGradient(Component component, Graphics graphics, List<?> gradient, Rectangle area, boolean vertical) {
        if (gradient == null || !(graphics instanceof Graphics2D)) {
            return false;
        }
        if (area.width <= 0 || area.height <= 0) {
            return true;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        GradientPainter.INSTANCE.paint(component, g2d, gradient, area, vertical);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT);
        return true;
    }

    public static void drawDisabledText(JComponent jComponent, Graphics graphics, String str, int textX, int textY, int mnemonicIndex) {
        String uiClassID = "Label";
        if (null != jComponent) {
            uiClassID = jComponent.getUIClassID();
            uiClassID = uiClassID.substring(0, uiClassID.length() - 2);
        }
        graphics.setColor(UIManager.getColor(uiClassID + ".disabledShadow"));
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, str, mnemonicIndex, textX + 1, textY + 1);
        graphics.setColor(UIManager.getColor(uiClassID + ".disabledText"));
        BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, str, mnemonicIndex, textX, textY);
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics, Font font) {
        if (jComponent != null) {
            return jComponent.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics) {
        return IsmPlafUtils.getFontMetrics(jComponent, graphics, graphics.getFont());
    }

    public static void drawBorderShadow(Graphics graphics, Point p1, Point p2, Point p3) {
        Color shadow = UIManager.getColor("shadow");
        graphics.setColor(shadow);
        graphics.drawLine((int)p1.getX() + 1, (int)p1.getY() + 1, (int)p2.getX() + 1, (int)p2.getY() + 1);
        graphics.drawLine((int)p2.getX() + 1, (int)p2.getY() + 1, (int)p3.getX() + 1, (int)p3.getY() + 1);
    }

    static {
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                robot = new Robot();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (kernel == null) {
            float[] elements = new float[9];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = 0.1f;
            }
            int mid = 2;
            elements[mid * mid] = 0.2f;
            kernel = new Kernel(3, 3, elements);
        }
    }

    private static class ShadowPopupFactory
    extends PopupFactory {
        private ShadowPopupFactory() {
        }

        @Override
        public Popup getPopup(Component owner, Component contents, int xAxis, int yAxis) {
            JPopupMenu popupMenu;
            if (!UIManager.getBoolean("Popup.enableShadow")) {
                return super.getPopup(owner, contents, xAxis, yAxis);
            }
            Dimension dim = contents.getPreferredSize();
            Rectangle bound = new Rectangle(xAxis, yAxis, dim.width + 4, dim.height + 4);
            BufferedImage backgroundImage = null;
            if (contents instanceof JPopupMenu && (popupMenu = (JPopupMenu)contents).getUI() instanceof IsmPopupMenuUI) {
                IsmPopupMenuUI ui = (IsmPopupMenuUI)popupMenu.getUI();
                backgroundImage = ui.getMenuBGCapture();
            }
            if (null == backgroundImage) {
                backgroundImage = IsmPlafUtils.captureScreen(bound, 255);
            }
            ShadowFrame frame = new ShadowFrame(contents, backgroundImage);
            return super.getPopup(owner, frame, xAxis, yAxis);
        }

        private static class ShadowFrame
        extends JComponent {
            private static final long serialVersionUID = 1L;

            public ShadowFrame(Component content, BufferedImage backgroundImage) {
                this.setLayout(new BorderLayout());
                this.add(content, "Center");
                this.setBorder(IsmBorders.getShadowBorder(backgroundImage));
            }
        }
    }

    private static abstract class CachedPainter {
        private static final Map<Object, Cache> CACHEMAP = new HashMap<Object, Cache>(0);

        public CachedPainter(int cacheCount) {
            CachedPainter.getCache(this.getClass()).setMaxCount(cacheCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Cache getCache(Object key) {
            Map<Object, Cache> map = CACHEMAP;
            synchronized (map) {
                Cache cache = CACHEMAP.get(key);
                if (cache == null) {
                    cache = new Cache(1);
                    CACHEMAP.put(key, cache);
                }
                return cache;
            }
        }

        public void paint(Component component, Graphics graphics, int xx, int yy, int ww, int hh, Object ... args) {
            if (ww <= 0 || hh <= 0) {
                return;
            }
            Class<?> key = this.getClass();
            GraphicsConfiguration config = component.getGraphicsConfiguration();
            Cache cache = CachedPainter.getCache(key);
            Image image = cache.getImage(key, config, ww, hh, args);
            int attempts = 0;
            boolean isVolatileImage = image instanceof VolatileImage;
            boolean isContentsLost = isVolatileImage && ((VolatileImage)image).contentsLost();
            boolean draw = false;
            do {
                draw = false;
                if (isVolatileImage) {
                    int vr = ((VolatileImage)image).validate(config);
                    if (vr == 2) {
                        ((VolatileImage)image).flush();
                        image = null;
                    } else if (vr == 1) {
                        draw = true;
                    }
                }
                if (null == image) {
                    image = this.createImage(component, ww, hh, config);
                    cache.setImage(key, config, ww, hh, args, image);
                    draw = true;
                }
                if (draw) {
                    Graphics g2 = image.getGraphics();
                    this.paintToImage(component, g2, ww, hh, args);
                    g2.dispose();
                }
                Rectangle area = new Rectangle(xx, yy, ww, hh);
                this.paintImage(component, graphics, area, image, args);
            } while (isContentsLost && ++attempts < 3);
        }

        protected abstract void paintToImage(Component var1, Graphics var2, int var3, int var4, Object[] var5);

        protected void paintImage(Component component, Graphics graphics, Rectangle area, Image image, Object[] args) {
            graphics.drawImage(image, (int)area.getX(), (int)area.getY(), null);
        }

        protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
            if (config == null) {
                return new BufferedImage(w, h, 1);
            }
            return config.createCompatibleVolatileImage(w, h);
        }

        private static class Entry {
            private GraphicsConfiguration graphConfig;
            private Object[] arguments;
            private Image image;
            private int width;
            private int height;

            Entry(GraphicsConfiguration config, int w, int h, Object[] args) {
                this.graphConfig = config;
                this.arguments = args;
                this.width = w;
                this.height = h;
            }

            public void setImage(Image image) {
                this.image = image;
            }

            public Image getImage() {
                return this.image;
            }

            public String toString() {
                String value = super.toString() + "[ graphicsConfig=" + this.graphConfig + ", image=" + this.image + ", w=" + this.width + ", h=" + this.height;
                return value;
            }

            public boolean equals(GraphicsConfiguration config, int w, int h, Object[] args) {
                boolean isArgsEquals;
                boolean isConfigEquals = this.graphConfig != null && this.graphConfig.equals(config);
                boolean isConfigNull = this.graphConfig == null && config == null;
                boolean isArgsNull = this.arguments == null && args == null;
                boolean bl = isArgsEquals = this.arguments != null && args != null && this.arguments.length == args.length;
                if (this.width == w && this.height == h && (isConfigEquals || isConfigNull)) {
                    if (isArgsNull) {
                        return true;
                    }
                    if (isArgsEquals) {
                        return this.equals0(args);
                    }
                }
                return false;
            }

            private boolean equals0(Object[] args) {
                for (int counter = args.length - 1; counter >= 0; --counter) {
                    if (this.arguments[counter].equals(args[counter])) continue;
                    return false;
                }
                return true;
            }
        }

        private static class Cache {
            private int maxCount;
            private List<SoftReference<Entry>> entries;

            Cache(int maxCount) {
                this.maxCount = maxCount;
                this.entries = new ArrayList<SoftReference<Entry>>(maxCount);
            }

            synchronized void setMaxCount(int maxCount) {
                this.maxCount = maxCount;
            }

            private synchronized Entry getEntry(GraphicsConfiguration config, int w, int h, Object[] args) {
                Entry entry;
                for (int counter = this.entries.size() - 1; counter >= 0; --counter) {
                    entry = this.entries.get(counter).get();
                    if (entry == null) {
                        this.entries.remove(counter);
                        continue;
                    }
                    if (!entry.equals(config, w, h, args)) continue;
                    return entry;
                }
                entry = new Entry(config, w, h, args);
                if (this.entries.size() == this.maxCount) {
                    this.entries.remove(0);
                }
                this.entries.add(new SoftReference<Entry>(entry));
                return entry;
            }

            public Image getImage(Object key, GraphicsConfiguration config, int w, int h, Object[] args) {
                Entry entry = this.getEntry(config, w, h, args);
                return entry.getImage();
            }

            public void setImage(Object key, GraphicsConfiguration config, int w, int h, Object[] args, Image image) {
                Entry entry = this.getEntry(config, w, h, args);
                entry.setImage(image);
            }
        }
    }

    private static class PointParams {
        float x;
        float y;
        Color currColor;

        public PointParams(float x, float y, Color currColor) {
            this.x = x;
            this.y = y;
            this.currColor = currColor;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public Color getCurrColor() {
            return this.currColor;
        }
    }

    public static class GradientPainter
    extends CachedPainter {
        public static final GradientPainter INSTANCE = new GradientPainter(8);
        private static final int IMAGE_SIZE = 64;
        private int width;
        private int height;

        GradientPainter(int count) {
            super(count);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Component component, Graphics2D graphics2D, List<?> gradient, Rectangle area, boolean isVertical) {
            int imageHeight;
            int imageWidth;
            if (isVertical) {
                imageWidth = 64;
                imageHeight = area.height;
            } else {
                imageWidth = area.width;
                imageHeight = 64;
            }
            Object object = component.getTreeLock();
            synchronized (object) {
                this.width = area.width;
                this.height = area.height;
                this.paint(component, graphics2D, (int)area.getX(), (int)area.getY(), imageWidth, imageHeight, new Object[]{gradient, isVertical});
            }
        }

        @Override
        protected void paintToImage(Component c, Graphics g, int w, int h, Object[] args) {
            Graphics2D g2 = (Graphics2D)g;
            List gradient = (List)args[0];
            boolean isVertical = (Boolean)args[1];
            if (isVertical) {
                this.drawVerticalGradient(g2, ((Number)gradient.get(0)).floatValue(), ((Number)gradient.get(1)).floatValue(), (Color)gradient.get(2), (Color)gradient.get(3), (Color)gradient.get(4), new Dimension(w, h));
            } else {
                this.drawHorizontalGradient(g2, ((Number)gradient.get(0)).floatValue(), ((Number)gradient.get(1)).floatValue(), (Color)gradient.get(2), (Color)gradient.get(3), (Color)gradient.get(4), new Dimension(w, h));
            }
        }

        @Override
        protected void paintImage(Component component, Graphics graphics, Rectangle area, Image image, Object[] args) {
            boolean isVertical = (Boolean)args[1];
            graphics.translate((int)area.getX(), (int)area.getY());
            if (isVertical) {
                int tileSize = 0;
                for (int counter = 0; counter < this.width; counter += 64) {
                    tileSize = Math.min(64, this.width - counter);
                    graphics.drawImage(image, counter, 0, counter + tileSize, this.height, 0, 0, tileSize, this.height, null);
                }
            } else {
                int tileSize = 0;
                for (int counter = 0; counter < this.height; counter += 64) {
                    tileSize = Math.min(64, this.height - counter);
                    graphics.drawImage(image, 0, counter, this.width, counter + tileSize, 0, 0, this.width, tileSize, null);
                }
            }
            graphics.translate(-((int)area.getX()), -((int)area.getY()));
        }

        private void drawVerticalGradient(Graphics2D graphics2D, float ratio1, float ratio2, Color c1, Color c2, Color c3, Dimension dimension) {
            PointParams p2;
            PointParams p1;
            int mid = (int)(ratio1 * (float)dimension.height);
            int mid2 = (int)(ratio2 * (float)dimension.height);
            if (mid > 0) {
                p1 = new PointParams(0.0f, 0.0f, c1);
                p2 = new PointParams(0.0f, mid, c2);
                graphics2D.setPaint(this.getGradient(p1, p2));
                graphics2D.fillRect(0, 0, dimension.width, mid);
            }
            if (mid2 > 0) {
                graphics2D.setColor(c2);
                graphics2D.fillRect(0, mid, dimension.width, mid2);
            }
            if (mid > 0) {
                p1 = new PointParams(0.0f, (float)mid + (float)mid2, c2);
                p2 = new PointParams(0.0f, (float)mid * 2.0f + (float)mid2, c1);
                graphics2D.setPaint(this.getGradient(p1, p2));
                graphics2D.fillRect(0, mid + mid2, dimension.width, mid);
            }
            if (dimension.height - mid * 2 - mid2 > 0) {
                p1 = new PointParams(0.0f, (float)mid * 2.0f + (float)mid2, c1);
                p2 = new PointParams(0.0f, dimension.height, c3);
                graphics2D.setPaint(this.getGradient(p1, p2));
                graphics2D.fillRect(0, mid * 2 + mid2, dimension.width, dimension.height - mid * 2 - mid2);
            }
        }

        private void drawHorizontalGradient(Graphics2D g, float ratio1, float ratio2, Color c1, Color c2, Color c3, Dimension dimension) {
            PointParams p2;
            PointParams p1;
            int mid = (int)(ratio1 * (float)dimension.width);
            int mid2 = (int)(ratio2 * (float)dimension.width);
            if (mid > 0) {
                p1 = new PointParams(0.0f, 0.0f, c1);
                p2 = new PointParams(mid, 0.0f, c2);
                g.setPaint(this.getGradient(p1, p2));
                g.fillRect(0, 0, mid, dimension.height);
            }
            if (mid2 > 0) {
                g.setColor(c2);
                g.fillRect(mid, 0, mid2, dimension.height);
            }
            if (mid > 0) {
                p1 = new PointParams((float)mid + (float)mid2, 0.0f, c2);
                p2 = new PointParams((float)mid * 2.0f + (float)mid2, 0.0f, c1);
                g.setPaint(this.getGradient(p1, p2));
                g.fillRect(mid + mid2, 0, mid, dimension.height);
            }
            if (dimension.width - mid * 2 - mid2 > 0) {
                p1 = new PointParams((float)mid * 2.0f + (float)mid2, 0.0f, c1);
                p2 = new PointParams(dimension.width, 0.0f, c3);
                g.setPaint(this.getGradient(p1, p2));
                g.fillRect(mid * 2 + mid2, 0, dimension.width - mid * 2 - mid2, dimension.height);
            }
        }

        private GradientPaint getGradient(PointParams p1, PointParams p2) {
            return new GradientPaint(p1.getX(), p1.getY(), p1.getCurrColor(), p2.getX(), p2.getY(), p2.getCurrColor(), true);
        }
    }

    public static enum OEMVender {
        Huawei;

    }

    public static enum LAFStyle {
        armor,
        blue,
        unify;

    }
}

